/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AIPromptBuilder {
    private final List<String> goals = new ArrayList<String>();
    private final List<String> instructions = new ArrayList<String>();
    private final List<String> examples = new ArrayList<String>();
    private final List<String> contexts = new ArrayList<String>();
    @Nullable
    private String databaseSnapshot;
    private final List<String> outputFormats = new ArrayList<String>();

    private AIPromptBuilder() {
    }

    @NotNull
    public static AIPromptBuilder create() {
        return new AIPromptBuilder();
    }

    public AIPromptBuilder addGoals(String ... goals) {
        this.goals.addAll(Arrays.asList(goals));
        return this;
    }

    public AIPromptBuilder addExamples(String ... examples) {
        this.examples.addAll(Arrays.asList(examples));
        return this;
    }

    public AIPromptBuilder addInstructions(String ... instructions) {
        this.instructions.addAll(Arrays.asList(instructions));
        return this;
    }

    public AIPromptBuilder addContexts(String ... contexts) {
        this.contexts.addAll(Arrays.asList(contexts));
        return this;
    }

    public AIPromptBuilder addDatabaseSnapshot(@NotNull String databaseSnapshot) {
        this.databaseSnapshot = databaseSnapshot.trim();
        return this;
    }

    public AIPromptBuilder addOutputFormats(String ... outputFormats) {
        this.outputFormats.addAll(Arrays.asList(outputFormats));
        return this;
    }

    public String build() {
        StringBuilder prompt = new StringBuilder();
        prompt.append("Goals:\n");
        this.goals.forEach(goal -> {
            StringBuilder stringBuilder2 = prompt.append("- ").append((String)goal).append("\n");
        });
        if (!this.instructions.isEmpty()) {
            prompt.append("\nInstructions:\n");
            this.instructions.forEach(instruction -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)instruction).append("\n");
            });
        }
        if (!this.examples.isEmpty()) {
            prompt.append("\nExamples:\n");
            this.examples.forEach(example -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)example).append("\n");
            });
        }
        prompt.append("\nContext:\n");
        this.contexts.forEach(context -> {
            StringBuilder stringBuilder2 = prompt.append("- ").append((String)context).append("\n");
        });
        if (this.databaseSnapshot != null && !this.databaseSnapshot.isBlank()) {
            prompt.append("\nDatabase Snapshot:\n");
            prompt.append(this.databaseSnapshot).append("\n");
        }
        if (!this.outputFormats.isEmpty()) {
            prompt.append("\nOutput Format:\n");
            this.outputFormats.forEach(outputFormat -> {
                StringBuilder stringBuilder2 = prompt.append("- ").append((String)outputFormat).append("\n");
            });
        }
        return prompt.toString();
    }

    public static String[] describeContext(@Nullable DBSLogicalDataSource dataSource) {
        BasicSQLDialect dialect = dataSource == null ? BasicSQLDialect.INSTANCE : SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource.getDataSourceContainer().getDataSource());
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        if (dataSource != null) {
            String currentCatalog;
            String currentSchema;
            DBPDataSourceInfo dsInfo;
            DBPDataSource ds = dataSource.getDataSourceContainer().getDataSource();
            DBPDataSourceInfo dBPDataSourceInfo = dsInfo = ds == null ? null : ds.getInfo();
            if (dataSource.getDataSourceContainer() instanceof DataSourceDescriptor) {
                lines.add((CallSite)((Object)("DBeaver connection name: " + dataSource.getDataSourceContainer().getName())));
                DBPDriver driver = dataSource.getDataSourceContainer().getDriver();
                if (ds instanceof JDBCDataSource) {
                    lines.add((CallSite)((Object)("JDBC driver: " + dsInfo.getDriverName() + " (" + dsInfo.getDriverVersion() + ")")));
                } else {
                    lines.add((CallSite)((Object)("Java driver: " + driver.getFullName() + ")")));
                }
            }
            if (!CommonUtils.isEmpty((String)(currentSchema = dataSource.getCurrentSchema()))) {
                lines.add((CallSite)((Object)("Current " + (dsInfo == null ? "Schema" : dsInfo.getSchemaTerm()) + ": " + currentSchema)));
            }
            if (!CommonUtils.isEmpty((String)(currentCatalog = dataSource.getCurrentCatalog()))) {
                lines.add((CallSite)((Object)("Current " + (dsInfo == null ? "Catalog" : dsInfo.getCatalogTerm()) + ": " + currentCatalog)));
            }
        }
        lines.add((CallSite)((Object)("SQL dialect: " + dialect.getDialectName())));
        lines.add((CallSite)((Object)("Current date and time: " + DateTimeFormatter.ISO_DATE_TIME.format(ZonedDateTime.now()))));
        return (String[])lines.toArray(String[]::new);
    }

    public static String[] createInstructionList(@Nullable DBSLogicalDataSource dataSource) {
        String useLanguage;
        String stringsQuoteRule;
        BasicSQLDialect dialect = dataSource == null ? BasicSQLDialect.INSTANCE : SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource.getDataSourceContainer().getDataSource());
        ArrayList<Object> instructions = new ArrayList<Object>();
        instructions.add("You are the DBeaver AI assistant.");
        instructions.add("Act as a database architect and SQL expert.");
        instructions.add("Rely only on the schema information provided below.");
        instructions.add("Stick strictly to " + dialect.getDialectName() + " syntax.");
        instructions.add("Do not invent columns, tables, or data that aren\u2019t explicitly defined.");
        String quoteRule = AIPromptBuilder.identifiersQuoteRule((SQLDialect)dialect);
        if (quoteRule != null) {
            instructions.add(quoteRule);
        }
        if ((stringsQuoteRule = AIPromptBuilder.stringsQuoteRule((SQLDialect)dialect)) != null) {
            instructions.add(stringsQuoteRule);
        }
        if (!CommonUtils.isEmpty((String)(useLanguage = DBWorkbench.getPlatform().getPreferenceStore().getString("ai.language")))) {
            instructions.add("Use " + useLanguage + " language in your responses.");
        } else {
            instructions.add("Use the same language as the user.");
        }
        return instructions.toArray(new String[0]);
    }

    @Nullable
    private static String identifiersQuoteRule(SQLDialect dialect) {
        String[][] identifierQuoteStrings = dialect.getIdentifierQuoteStrings();
        if (identifierQuoteStrings == null || identifierQuoteStrings.length == 0) {
            return null;
        }
        return "Use (" + identifierQuoteStrings[0][0] + identifierQuoteStrings[0][1] + ") to quote identifiers if needed.";
    }

    private static String stringsQuoteRule(SQLDialect dialect) {
        String[][] stringQuoteStrings = dialect.getStringQuoteStrings();
        if (stringQuoteStrings.length == 0) {
            return null;
        }
        return "Use (" + stringQuoteStrings[0][0] + stringQuoteStrings[0][1] + ") to quote strings.";
    }
}

