/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;

public class BlockTextSelection
extends TextSelection
implements IBlockTextSelection {
    private final int fStartLine;
    private final int fStartColumn;
    private final int fEndLine;
    private final int fEndColumn;
    private final int fTabWidth;

    public BlockTextSelection(IDocument document, int startLine, int startColumn, int endLine, int endColumn, int tabWidth) {
        super(document, BlockTextSelection.computeOffset(document, startLine, startColumn), BlockTextSelection.computeOffset(document, endLine, endColumn) - BlockTextSelection.computeOffset(document, startLine, startColumn));
        Assert.isLegal((startLine >= 0 ? 1 : 0) != 0);
        Assert.isLegal((startColumn >= 0 ? 1 : 0) != 0);
        Assert.isLegal((endLine >= startLine ? 1 : 0) != 0);
        Assert.isLegal((endColumn >= 0 ? 1 : 0) != 0);
        Assert.isLegal((tabWidth >= 0 ? 1 : 0) != 0);
        this.fStartLine = startLine;
        this.fStartColumn = startColumn;
        this.fEndLine = endLine;
        this.fEndColumn = endColumn;
        this.fTabWidth = tabWidth > 0 ? tabWidth : 8;
    }

    private static int computeOffset(IDocument document, int line, int column) {
        try {
            IRegion lineInfo = document.getLineInformation(line);
            int offsetInLine = Math.min(column, lineInfo.getLength());
            return lineInfo.getOffset() + offsetInLine;
        }
        catch (BadLocationException x) {
            if (line < 0) {
                return 0;
            }
            return document.getLength();
        }
    }

    @Override
    public int getStartLine() {
        return this.fStartLine;
    }

    @Override
    public int getStartColumn() {
        return this.fStartColumn;
    }

    @Override
    public int getEndLine() {
        return this.fEndLine;
    }

    @Override
    public int getEndColumn() {
        return this.fEndColumn;
    }

    @Override
    public String getText() {
        IDocument document = this.getDocument();
        if (document != null) {
            try {
                return new SelectionProcessor(document, this.fTabWidth).getText(this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return super.getText();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fEndColumn;
        result = 31 * result + this.fEndLine;
        result = 31 * result + this.fStartColumn;
        result = 31 * result + this.fStartLine;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BlockTextSelection other = (BlockTextSelection)obj;
        if (this.fEndColumn != other.fEndColumn) {
            return false;
        }
        if (this.fEndLine != other.fEndLine) {
            return false;
        }
        if (this.fStartColumn != other.fStartColumn) {
            return false;
        }
        return this.fStartLine == other.fStartLine;
    }

    @Override
    public IRegion[] getRegions() {
        IDocument document = this.getDocument();
        if (document != null) {
            try {
                return new SelectionProcessor(document, this.fTabWidth).getRanges(this);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return new IRegion[]{new Region(this.getOffset(), this.getLength())};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockTextSelection [offset: ").append(this.getOffset());
        sb.append(", startLine: ").append(this.fStartLine);
        if (this.fEndLine != this.fStartLine) {
            sb.append(", endLine: ").append(this.fEndLine);
        }
        sb.append(", startColumn: ").append(this.fStartColumn);
        if (this.fEndColumn != this.fStartColumn) {
            sb.append(", endColumn").append(this.fEndColumn);
        }
        if (this.getLength() != 0) {
            sb.append(", text: ").append(this.getText());
        }
        if (this.getDocument() != null) {
            sb.append(", document: ").append(this.getDocument());
        }
        sb.append("]");
        return sb.toString();
    }
}

