/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={IPlatformConfigurationFactory.class})
public class PlatformConfigurationFactory
implements IPlatformConfigurationFactory {
    private Location configLocation;

    @Override
    public IPlatformConfiguration getCurrentPlatformConfiguration() {
        try {
            PlatformConfiguration.startup(this.configLocation);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            Utils.log(Utils.newStatus(message, e));
        }
        return PlatformConfiguration.getCurrent();
    }

    @Override
    public IPlatformConfiguration getPlatformConfiguration(URL url) throws IOException {
        try {
            return new PlatformConfiguration(url);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public IPlatformConfiguration getPlatformConfiguration(URL url, URL loc) throws IOException {
        try {
            return new PlatformConfiguration(url, loc);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    @Activate
    public void startup() {
        this.configLocation = Utils.getConfigurationLocation();
        if (!this.configLocation.isReadOnly()) {
            try {
                URL privateURL = new URL(this.configLocation.getURL(), "org.eclipse.update");
                File f = new File(privateURL.getFile());
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Deactivate
    public void shutdown() {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

