/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.runtime.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.model.core.ModelParser;
import org.openhab.core.model.rule.RulesStandaloneSetup;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ModelParser.class, RuleRuntimeActivator.class})
public class RuleRuntimeActivator
implements ModelParser {
    private final Logger logger = LoggerFactory.getLogger(RuleRuntimeActivator.class);
    private final ScriptServiceUtil scriptServiceUtil;
    private final ScriptEngine scriptEngine;

    @Activate
    public RuleRuntimeActivator(@Reference ScriptEngine scriptEngine, @Reference ScriptServiceUtil scriptServiceUtil) {
        this.scriptEngine = scriptEngine;
        this.scriptServiceUtil = scriptServiceUtil;
    }

    public void activate(BundleContext bc) throws Exception {
        RulesStandaloneSetup.doSetup((ScriptServiceUtil)this.scriptServiceUtil, (ScriptEngine)this.scriptEngine);
        this.logger.debug("Registered 'rule' configuration parser");
    }

    public void deactivate() throws Exception {
        RulesStandaloneSetup.unregister();
    }

    public String getExtension() {
        return "rules";
    }
}

