/* do not edit automatically generated by mc from Lists.  */
/* Lists.def provides an unordered list manipulation package.

Copyright (C) 2001-2026 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_Lists_H)
#   define _Lists_H

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GSymbolKey.h"

#   if defined (_Lists_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (Lists_List_D)
#  define Lists_List_D
   typedef void *Lists_List;
#endif


/*
   InitList - creates a new list, l.
*/

EXTERN void Lists_InitList (Lists_List *l);

/*
   KillList - deletes the complete list, l.
*/

EXTERN void Lists_KillList (Lists_List *l);

/*
   PutItemIntoList - places a CARDINAL, c, into list, l.
*/

EXTERN void Lists_PutItemIntoList (Lists_List l, unsigned int c);

/*
   GetItemFromList - retrieves the nth WORD from list, l.
*/

EXTERN unsigned int Lists_GetItemFromList (Lists_List l, unsigned int n);

/*
   GetIndexOfList - returns the index for WORD, c, in list, l.
                    If more than one CARDINAL, c, exists the index
                    for the first is returned.
*/

EXTERN unsigned int Lists_GetIndexOfList (Lists_List l, unsigned int c);

/*
   NoOfItemsInList - returns the number of items in list, l.
*/

EXTERN unsigned int Lists_NoOfItemsInList (Lists_List l);

/*
   IncludeItemIntoList - adds a WORD, c, into a list providing
                         the value does not already exist.
*/

EXTERN void Lists_IncludeItemIntoList (Lists_List l, unsigned int c);

/*
   RemoveItemFromList - removes a WORD, c, from a list.
                        It assumes that this value only appears once.
*/

EXTERN void Lists_RemoveItemFromList (Lists_List l, unsigned int c);

/*
   IsItemInList - returns true if a WORD, c, was found in list, l.
*/

EXTERN bool Lists_IsItemInList (Lists_List l, unsigned int c);

/*
   ForeachItemInListDo - calls procedure, P, foreach item in list, l.
*/

EXTERN void Lists_ForeachItemInListDo (Lists_List l, SymbolKey_PerformOperation P);

/*
   DuplicateList - returns a duplicate list derived from, l.
*/

EXTERN Lists_List Lists_DuplicateList (Lists_List l);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
