//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// This class allows your application to produce a higher fidelity, PDF screenshot to the user. Set the delegate so that when a screenshot is taken, screenshots can show the full document content from the application.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscreenshotservice?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIScreenshotService;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIScreenshotService {}
);

impl UIScreenshotService {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        /// Assign a delegate in order to send PDF data to accompany the screenshot taken by the user
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self)
            -> Option<Retained<ProtocolObject<dyn UIScreenshotServiceDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIScreenshotServiceDelegate>>,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIScene",
            feature = "UIWindowScene"
        ))]
        /// The window scene associated with the screenshot service
        #[unsafe(method(windowScene))]
        #[unsafe(method_family = none)]
        pub fn windowScene(&self) -> Option<Retained<UIWindowScene>>;
    );
}

/// UIScreenshotService.
#[cfg(all(
    feature = "UIResponder",
    feature = "UIScene",
    feature = "UIWindowScene"
))]
impl UIWindowScene {
    extern_methods!(
        /// The screenshot object associated with the scene
        ///
        /// This is non-null if the screenshot service is available for this window scene
        #[unsafe(method(screenshotService))]
        #[unsafe(method_family = none)]
        pub fn screenshotService(&self) -> Option<Retained<UIScreenshotService>>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiscreenshotservicedelegate?language=objc)
    pub unsafe trait UIScreenshotServiceDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "block2", feature = "objc2-core-foundation"))]
        /// The delegate method to send the PDF data to screenshots
        ///
        /// The delegate is required to send the data via the completion handler
        ///
        /// Parameter `screenshotService`: The screenshot service object associated per scene
        ///
        /// Parameter `completionHandler`: The block to execute when the PDF data is ready.
        /// If no PDF data is available, data can be nil. The indexOfCurrentPage is zero-based, and is the index of the current page of the snapshotted PDF. The rectInCurrentPage is the rect in PDF coordinates with respect to the current page. If the receiver cannot provide the visible area, pass CGRectZero for rectInCurrentPage.
        #[optional]
        #[unsafe(method(screenshotService:generatePDFRepresentationWithCompletion:))]
        #[unsafe(method_family = none)]
        fn screenshotService_generatePDFRepresentationWithCompletion(
            &self,
            screenshot_service: &UIScreenshotService,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSData, NSInteger, CGRect)>,
        );
    }
);
