/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import com.google.auto.value.processor.AbortProcessingException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class ErrorReporter {
    private final Messager messager;
    private int errorCount;

    ErrorReporter(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    void reportNote(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg, e);
    }

    void reportWarning(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg, e);
    }

    void reportError(String msg, Element e) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
        ++this.errorCount;
    }

    void abortWithError(String msg, Element e) {
        this.reportError(msg, e);
        throw new AbortProcessingException();
    }

    int errorCount() {
        return this.errorCount;
    }

    void abortIfAnyError() {
        if (this.errorCount > 0) {
            throw new AbortProcessingException();
        }
    }
}

