/*
 * Copyright 2012 by Troyer Information Systems GmbH
 * All Rights Reserved. 
 */
package com.gtouch5.shared.data.store.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * StoreEvent is triggered asynchronously on {@link Type} INSERT, UPDATE, DELETE
 * 
 * @author kht
 *
 * @param <M>
 */
public class StoreEvent<M> extends GwtEvent<StoreHandler<M>> {

	/**
	 * Handler type.
	 */
	protected static Type<StoreHandler<?>> TYPE;

	protected static synchronized void flush(StoreEvent<?> event) {
	}
	
	protected static synchronized boolean flushNext() {
		return false;
	}
	
	protected static synchronized <T> StoreEvent<T> trigger(StoreEvent<T> event) {
		return event;
	}
	
	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static synchronized Type<StoreHandler<?>> getType() {
		if (TYPE == null) {
			TYPE = new Type<StoreHandler<?>>();
		}
		return TYPE;
	}

	/**
	 * Creates a store event.
	 */
	protected StoreEvent() {
	}

	protected StoreEvent(Object source) {
		setSource(source);
	}

	@SuppressWarnings({"unchecked", "rawtypes"})
	@Override
	public final Type<StoreHandler<M>> getAssociatedType() {
		return (Type) TYPE;
	}

	@Override
	public synchronized String toDebugString() {
		return super.toDebugString();
	}

	@Override
	protected synchronized void dispatch(StoreHandler<M> handler) {
		handler.onStoreChange(this);
	}
}
