/*
 * Decompiled with CFR 0.152.
 */
package io.vavr;

import io.vavr.Value;
import io.vavr.collection.Iterator;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T>
implements Value<T>,
Serializable,
Supplier<T> {
    private static final long serialVersionUID = 1L;
    private volatile transient Supplier<? extends T> supplier;
    private T value;

    private Lazy(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        if (supplier instanceof Lazy) {
            return (Lazy)supplier;
        }
        return new Lazy<T>(supplier);
    }

    @Override
    public T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    private synchronized T computeValue() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            this.value = s.get();
            this.supplier = null;
        }
        return this.value;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean isEvaluated() {
        return this.supplier == null;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public boolean isSingleValued() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterator.of(this.get());
    }

    @Override
    public String stringPrefix() {
        return "Lazy";
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Lazy && Objects.equals(((Lazy)o).get(), this.get());
    }

    public int hashCode() {
        return Objects.hashCode(this.get());
    }

    @Override
    public String toString() {
        return this.stringPrefix() + "(" + (!this.isEvaluated() ? "?" : this.value) + ")";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.get();
        s.defaultWriteObject();
    }
}

