/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.contributors.helpers;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.contributors.helpers.CompletionHelpersKt;
import org.jetbrains.kotlin.idea.completion.contributors.helpers.SuperCallLookupObject;
import org.jetbrains.kotlin.idea.completion.lookups.factories.InsertionUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0013\u0010\u0016\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "replaceWithClassIdAndShorten", "lookupObject", "Lorg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallLookupObject;", "getCorrectedTailOffsetForSuperCall", "", "(Lcom/intellij/codeInsight/completion/InsertionContext;)Ljava/lang/Integer;", "skipTokensAndGetExpectedTokenOrNull", "Lcom/intellij/psi/PsiElement;", "tokensToSkip", "Lcom/intellij/psi/tree/TokenSet;", "expectedToken", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "TOKENS_BEFORE_CLOSING_ANGLE_BRACKET", "Lorg/jetbrains/annotations/NotNull;", "kotlin.completion.impl.k2"})
@SourceDebugExtension(value={"SMAP\nFirSuperEntriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuperEntriesProvider.kt\norg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n183#2,2:82\n1#3:84\n*S KotlinDebug\n*F\n+ 1 FirSuperEntriesProvider.kt\norg/jetbrains/kotlin/idea/completion/contributors/helpers/SuperCallInsertionHandler\n*L\n70#1:82,2\n*E\n"})
public final class SuperCallInsertionHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final SuperCallInsertionHandler INSTANCE = new SuperCallInsertionHandler();
    @NotNull
    private static final TokenSet TOKENS_BEFORE_CLOSING_ANGLE_BRACKET;

    private SuperCallInsertionHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.contributors.helpers.SuperCallLookupObject");
        SuperCallLookupObject lookupObject = (SuperCallLookupObject)object;
        this.replaceWithClassIdAndShorten(lookupObject, context);
        if (context.getCompletionChar() != '.') {
            CompletionHelpersKt.insertStringAndInvokeCompletion(context, ".");
        }
    }

    private final void replaceWithClassIdAndShorten(SuperCallLookupObject lookupObject, InsertionContext context) {
        String string = lookupObject.getReplaceTo();
        if (string == null) {
            return;
        }
        String replaceTo = string;
        Integer n = this.getCorrectedTailOffsetForSuperCall(context);
        context.setTailOffset(n != null ? n.intValue() : context.getTailOffset());
        if (lookupObject.getShortenReferencesInReplaced()) {
            InsertionUtilsKt.insertAndShortenReferencesInStringUsingTemporarySuffix$default(context, replaceTo, null, 2, null);
        } else {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)replaceTo);
            context.commitDocument();
        }
    }

    private final Integer getCorrectedTailOffsetForSuperCall(InsertionContext context) {
        Integer n;
        PsiElement dotToken;
        PsiElement psiElement;
        PsiElement gtToken;
        PsiElement psiElement2 = context.getFile().findElementAt(context.getStartOffset());
        if (psiElement2 == null) {
            return null;
        }
        PsiElement tokenAtPosition = psiElement2;
        KtSingleValueToken ktSingleValueToken = KtTokens.GT;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"GT");
        PsiElement psiElement3 = gtToken = this.skipTokensAndGetExpectedTokenOrNull(tokenAtPosition, TOKENS_BEFORE_CLOSING_ANGLE_BRACKET, ktSingleValueToken);
        if (psiElement3 != null) {
            TokenSet tokenSet = KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACE_OR_COMMENT_BIT_SET");
            KtSingleValueToken ktSingleValueToken2 = KtTokens.DOT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"DOT");
            psiElement = this.skipTokensAndGetExpectedTokenOrNull(psiElement3, tokenSet, ktSingleValueToken2);
        } else {
            psiElement = null;
        }
        PsiElement psiElement4 = dotToken = psiElement;
        if (psiElement4 != null) {
            n = PsiUtilsKt.getEndOffset(psiElement4);
        } else {
            PsiElement psiElement5 = gtToken;
            n = psiElement5 != null ? Integer.valueOf(PsiUtilsKt.getEndOffset((PsiElement)psiElement5)) : null;
        }
        return n;
    }

    private final PsiElement skipTokensAndGetExpectedTokenOrNull(PsiElement $this$skipTokensAndGetExpectedTokenOrNull, TokenSet tokensToSkip, KtSingleValueToken expectedToken) {
        Object object;
        Object v0;
        block3: {
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.getNextLeafs((PsiElement)$this$skipTokensAndGetExpectedTokenOrNull);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!tokensToSkip.contains(it.getNode().getElementType()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiElement psiElement = v0;
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it = psiElement2 = psiElement;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)expectedToken) ? psiElement2 : null;
        } else {
            object = null;
        }
        return object;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IDENTIFIER, KtTokens.DOT, KtTokens.LT};
        tokenSetArray[0] = TokenSet.create((IElementType[])iElementTypeArray);
        tokenSetArray[1] = KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET;
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        TOKENS_BEFORE_CLOSING_ANGLE_BRACKET = tokenSet;
    }
}

