/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001d\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001d\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001bH\u0002J \u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0002J-\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b)J;\u0010*\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\b\u0002\u0010-\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b.R'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinTypedHandlerHelper;", "", "<init>", "()V", "PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_base_code_insight_minimal", "()Lcom/intellij/openapi/util/Key;", "autoPopupParameterInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "autoPopupParameterInfo$kotlin_base_code_insight_minimal", "autoPopupMemberLookup", "autoPopupMemberLookup$kotlin_base_code_insight_minimal", "isLabelCompletion", "", "chars", "", "offset", "isAnnotationCompletion", "atElement", "Lcom/intellij/psi/PsiElement;", "autoPopupAt", "autoPopupAt$kotlin_base_code_insight_minimal", "autoPopupColon", "autoPopupColon$kotlin_base_code_insight_minimal", "isAnnotationAfterUseSiteTargetCompletion", "element", "endsWith", "text", "", "dataClassValParameterInsert", "file", "Lcom/intellij/psi/PsiFile;", "beforeType", "dataClassValParameterInsert$kotlin_base_code_insight_minimal", "autoIndentCase", "klass", "Ljava/lang/Class;", "forFirstElement", "autoIndentCase$kotlin_base_code_insight_minimal", "kotlin.base.code-insight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinTypedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTypedHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinTypedHandlerHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n1#2:360\n*E\n"})
public final class KotlinTypedHandlerHelper {
    @NotNull
    public static final KotlinTypedHandlerHelper INSTANCE = new KotlinTypedHandlerHelper();
    @NotNull
    private static final Key<Integer> PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY;

    private KotlinTypedHandlerHelper() {
    }

    @NotNull
    public final Key<Integer> getPREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY$kotlin_base_code_insight_minimal() {
        return PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY;
    }

    public final void autoPopupParameterInfo$kotlin_base_code_insight_minimal(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        HighlighterIterator highlighterIterator = editor.getHighlighter().createIterator(offset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        IElementType tokenType = iterator.getTokenType();
        if (KtTokens.COMMENTS.contains(tokenType) || tokenType == KtTokens.REGULAR_STRING_PART || tokenType == KtTokens.INTERPOLATION_PREFIX || tokenType == KtTokens.OPEN_QUOTE || tokenType == KtTokens.CHARACTER_LITERAL) {
            return;
        }
        AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, null);
    }

    public final void autoPopupMemberLookup$kotlin_base_code_insight_minimal(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, arg_0 -> KotlinTypedHandlerHelper.autoPopupMemberLookup$lambda$1(arg_0 -> KotlinTypedHandlerHelper.autoPopupMemberLookup$lambda$0(editor, arg_0), arg_0));
    }

    private final boolean isLabelCompletion(CharSequence chars, int offset) {
        return this.endsWith(chars, offset, "this@") || this.endsWith(chars, offset, "return@") || this.endsWith(chars, offset, "break@") || this.endsWith(chars, offset, "continue@");
    }

    private final boolean isAnnotationCompletion(PsiElement atElement) {
        PsiErrorElement errorElement;
        PsiElement psiElement = atElement.getParent();
        PsiErrorElement psiErrorElement = errorElement = psiElement instanceof PsiErrorElement ? (PsiErrorElement)psiElement : null;
        PsiElement it = psiErrorElement != null ? psiErrorElement.getParent() : null;
        boolean bl = false;
        return it instanceof KtDeclarationModifierList || it instanceof KtFileAnnotationList;
    }

    public final void autoPopupAt$kotlin_base_code_insight_minimal(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, arg_0 -> KotlinTypedHandlerHelper.autoPopupAt$lambda$4(arg_0 -> KotlinTypedHandlerHelper.autoPopupAt$lambda$3(editor, arg_0), arg_0));
    }

    public final void autoPopupColon$kotlin_base_code_insight_minimal(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, arg_0 -> KotlinTypedHandlerHelper.autoPopupColon$lambda$6(arg_0 -> KotlinTypedHandlerHelper.autoPopupColon$lambda$5(editor, arg_0), arg_0));
    }

    private final boolean isAnnotationAfterUseSiteTargetCompletion(PsiElement element) {
        Object object;
        block6: {
            block5: {
                PsiElement psiElement;
                PsiElement identifierElement;
                Object object2;
                PsiElement psiElement2;
                PsiElement it = psiElement2 = element;
                boolean bl = false;
                Object colonElement = Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.COLON) ? psiElement2 : null;
                PsiElement psiElement3 = colonElement;
                if (psiElement3 != null && (psiElement3 = psiElement3.getPrevSibling()) != null) {
                    PsiElement psiElement4;
                    PsiElement it2 = psiElement4 = psiElement3;
                    boolean bl2 = false;
                    object2 = Intrinsics.areEqual((Object)it2.getNode().getElementType(), (Object)KtTokens.IDENTIFIER) ? psiElement4 : null;
                } else {
                    object2 = null;
                }
                if ((object = (identifierElement = object2)) == null || (object = object.getPrevSibling()) == null) break block5;
                PsiElement it3 = psiElement = object;
                boolean bl3 = false;
                object = Intrinsics.areEqual((Object)it3.getNode().getElementType(), (Object)KtTokens.AT) ? psiElement : null;
                if (object != null) break block6;
            }
            return false;
        }
        PsiElement atElement = object;
        return this.isAnnotationCompletion(atElement);
    }

    private final boolean endsWith(CharSequence chars, int offset, String text) {
        return offset < text.length() ? false : Intrinsics.areEqual((Object)((Object)chars.subSequence(offset - text.length(), offset)).toString(), (Object)text);
    }

    public final void dataClassValParameterInsert$kotlin_base_code_insight_minimal(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, boolean beforeType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!KotlinEditorOptions.getInstance().isAutoAddValKeywordToDataClassParameters()) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        int commaOffset = editor.getCaretModel().getOffset();
        if (!beforeType) {
            --commaOffset;
        }
        if (commaOffset < 1) {
            return;
        }
        PsiElement psiElement = file.findElementAt(commaOffset);
        if (psiElement == null) {
            return;
        }
        PsiElement elementOnCaret = psiElement;
        boolean contextMatched = false;
        PsiElement parentElement = elementOnCaret.getParent();
        if (parentElement instanceof KtParameterList && (parentElement = ((KtParameterList)parentElement).getParent()) instanceof KtPrimaryConstructor && (parentElement = ((KtPrimaryConstructor)parentElement).getParent()) instanceof KtClass) {
            PsiElement klassElement = parentElement;
            boolean bl = contextMatched = ((KtClass)klassElement).isData() || ((KtClass)klassElement).isInline() || ((KtClass)klassElement).isValue();
        }
        if (!contextMatched) {
            return;
        }
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementOnCaret);
        KtParameter ktParameter = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
        if (ktParameter == null) {
            return;
        }
        KtParameter leftElement = ktParameter;
        KtTypeReference ktTypeReference = leftElement.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (leftElement.hasValOrVar()) {
            return;
        }
        if (typeReference.getTextLength() == 0) {
            return;
        }
        document2.insertString(leftElement.getTextOffset(), (CharSequence)"val ");
    }

    public final boolean autoIndentCase$kotlin_base_code_insight_minimal(@NotNull Editor editor, @NotNull Project project, @NotNull PsiFile file, @NotNull Class<?> klass, boolean forFirstElement) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null) {
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)currElement);
            if (!(!forFirstElement || prevLeaf instanceof PsiWhiteSpace && ((PsiWhiteSpace)prevLeaf).textContains('\n'))) {
                return false;
            }
            PsiElement parent = currElement.getParent();
            if (klass.isInstance(parent)) {
                int curElementLength = currElement.getText().length();
                if (offset < curElementLength) {
                    return false;
                }
                if (forFirstElement) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset - curElementLength);
                } else {
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                    if (document != null) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, DocumentUtil.getLineStartOffset((int)offset, (Document)document));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean autoIndentCase$kotlin_base_code_insight_minimal$default(KotlinTypedHandlerHelper kotlinTypedHandlerHelper, Editor editor, Project project, PsiFile psiFile, Class clazz, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return kotlinTypedHandlerHelper.autoIndentCase$kotlin_base_code_insight_minimal(editor, project, psiFile, clazz, bl);
    }

    private static final boolean autoPopupMemberLookup$lambda$0(Editor $editor, PsiFile file) {
        int offset = $editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement lastToken = psiElement;
        IElementType iElementType = lastToken.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (elementType == KtTokens.DOT || elementType == KtTokens.SAFE_ACCESS) {
            return true;
        }
        if (elementType == KtTokens.REGULAR_STRING_PART && lastToken.getTextRange().getStartOffset() == offset - 1) {
            PsiElement prevSibling = lastToken.getParent().getPrevSibling();
            return prevSibling instanceof KtSimpleNameStringTemplateEntry;
        }
        return false;
    }

    private static final boolean autoPopupMemberLookup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean autoPopupAt$lambda$3(Editor $editor, PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int offset = $editor.getCaretModel().getOffset();
        CharSequence charSequence = $editor.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        PsiElement elementAtCaret = file.findElementAt(offset - 1);
        PsiElement psiElement = elementAtCaret;
        if (psiElement == null || (psiElement = psiElement.getNode()) == null || (psiElement = psiElement.getElementType()) == null) {
            return false;
        }
        PsiElement lastNodeType = psiElement;
        return lastNodeType == KDocTokens.TEXT || lastNodeType == KtTokens.AT && (INSTANCE.isLabelCompletion(chars, offset) || INSTANCE.isAnnotationCompletion(elementAtCaret));
    }

    private static final boolean autoPopupAt$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean autoPopupColon$lambda$5(Editor $editor, PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int offset = $editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement lastElement = psiElement;
        return lastElement.getNode().getElementType() == KtTokens.COLONCOLON || INSTANCE.isAnnotationAfterUseSiteTargetCompletion(lastElement);
    }

    private static final boolean autoPopupColon$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY = key;
    }
}

