/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.profiler.ultimate.hprof.utils.IntList;
import java.util.EmptyStackException;

public class IntBufferStack
implements AutoCloseable {
    private final IntList data;
    private int size;

    public IntBufferStack(int maximumSize) {
        this.data = this.create(maximumSize);
        this.size = 0;
    }

    protected IntList create(int maximumSize) {
        return new IntList.InMemory(maximumSize);
    }

    public void push(int t) {
        this.data.put(this.size++, t);
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data.get(this.size - 1);
    }

    public int pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data.get(--this.size);
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof IntBufferStack) {
            IntBufferStack otherStack = (IntBufferStack)o;
            if (this.size != otherStack.size) {
                return false;
            }
            for (int i = 0; i < otherStack.size; ++i) {
                if (this.data.get(i) == otherStack.data.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
    }

    @Override
    public void close() {
        this.data.close();
    }
}

