/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.PointType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class LocationItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(PointType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(PointType.class, RefreshType.class);

    public LocationItem(String name) {
        super("Location", name);
    }

    public void send(PointType command) {
        this.internalSend(command, null);
    }

    public void send(PointType command, @Nullable String source) {
        this.internalSend(command, source);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    public DecimalType distanceFrom(@Nullable LocationItem awayItem) {
        if (awayItem != null && awayItem.state instanceof PointType) {
            PointType awayPoint = (PointType)awayItem.state;
            State state = this.state;
            if (state instanceof PointType) {
                PointType thisPoint = (PointType)state;
                return thisPoint.distanceFrom(awayPoint);
            }
        }
        return new DecimalType(-1);
    }

    @Override
    public void setState(State state, @Nullable String source) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            this.applyState(state, source);
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof PointType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

