/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.fileformat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.core.fileformat.FileFormatChannelLinkDTO;
import org.openhab.core.io.rest.core.fileformat.FileFormatItemDTO;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilderFactory;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.dto.GroupItemDTO;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.items.dto.MetadataDTO;
import org.openhab.core.thing.link.ItemChannelLink;

@NonNullByDefault
public class FileFormatItemDTOMapper {
    public static FileFormatItemDTO map(Item item, Collection<Metadata> metadata, @Nullable String format, Collection<ItemChannelLink> channelLinks) {
        ItemDTO itemDto = ItemDTOMapper.map((Item)item);
        FileFormatItemDTO dto = new FileFormatItemDTO(itemDto, itemDto instanceof GroupItemDTO);
        dto.format = format;
        LinkedHashMap<String, MetadataDTO> metadataDTO = new LinkedHashMap<String, MetadataDTO>();
        metadata.forEach(md -> {
            if (item.getName().equals(md.getUID().getItemName())) {
                MetadataDTO mdDTO = new MetadataDTO();
                mdDTO.value = md.getValue();
                mdDTO.config = md.getConfiguration().isEmpty() ? null : md.getConfiguration();
                metadataDTO.put(md.getUID().getNamespace(), mdDTO);
            }
        });
        if (!metadataDTO.isEmpty()) {
            dto.metadata = metadataDTO;
        }
        ArrayList<FileFormatChannelLinkDTO> channelLinksDTO = new ArrayList<FileFormatChannelLinkDTO>();
        channelLinks.forEach(link -> {
            if (item.getName().equals(link.getItemName())) {
                channelLinksDTO.add(new FileFormatChannelLinkDTO(link.getLinkedUID().getAsString(), link.getConfiguration().getProperties().isEmpty() ? null : link.getConfiguration().getProperties()));
            }
        });
        if (!channelLinksDTO.isEmpty()) {
            dto.channelLinks = channelLinksDTO;
        }
        return dto;
    }

    public static @Nullable Item map(FileFormatItemDTO dto, ItemBuilderFactory itemBuilderFactory) {
        if ("Group".equals(dto.type)) {
            GroupItemDTO groupDto = new GroupItemDTO();
            groupDto.type = dto.type;
            groupDto.name = dto.name;
            groupDto.label = dto.label;
            groupDto.category = dto.category;
            groupDto.tags = dto.tags;
            groupDto.groupNames = dto.groupNames;
            groupDto.groupType = dto.groupType;
            groupDto.function = dto.function;
            return ItemDTOMapper.map((ItemDTO)groupDto, (ItemBuilderFactory)itemBuilderFactory);
        }
        return ItemDTOMapper.map((ItemDTO)dto, (ItemBuilderFactory)itemBuilderFactory);
    }

    public static Collection<Metadata> mapMetadata(FileFormatItemDTO dto) {
        MetadataKey key;
        String name = dto.name;
        ArrayList<Metadata> metadata = new ArrayList<Metadata>();
        if (dto.channelLinks != null) {
            for (FileFormatChannelLinkDTO fileFormatChannelLinkDTO : dto.channelLinks) {
                key = new MetadataKey("channel", name);
                metadata.add(new Metadata(key, fileFormatChannelLinkDTO.channelUID, fileFormatChannelLinkDTO.configuration));
            }
        }
        if (dto.metadata != null) {
            for (Map.Entry entry : dto.metadata.entrySet()) {
                key = new MetadataKey((String)entry.getKey(), name);
                metadata.add(new Metadata(key, Objects.requireNonNull(((MetadataDTO)entry.getValue()).value), ((MetadataDTO)entry.getValue()).config));
            }
        }
        return metadata;
    }
}

