// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type LogsRequest struct {
	RequestContext *RequestContext
	LogsData       LogsData
	FormatVersion  uint32
}

var (
	protoPoolLogsRequest = sync.Pool{
		New: func() any {
			return &LogsRequest{}
		},
	}
)

func NewLogsRequest() *LogsRequest {
	if !UseProtoPooling.IsEnabled() {
		return &LogsRequest{}
	}
	return protoPoolLogsRequest.Get().(*LogsRequest)
}

func DeleteLogsRequest(orig *LogsRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteRequestContext(orig.RequestContext, true)
	DeleteLogsData(&orig.LogsData, false)

	orig.Reset()
	if nullable {
		protoPoolLogsRequest.Put(orig)
	}
}

func CopyLogsRequest(dest, src *LogsRequest) *LogsRequest {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLogsRequest()
	}
	dest.RequestContext = CopyRequestContext(dest.RequestContext, src.RequestContext)

	CopyLogsData(&dest.LogsData, &src.LogsData)

	dest.FormatVersion = src.FormatVersion

	return dest
}

func CopyLogsRequestSlice(dest, src []LogsRequest) []LogsRequest {
	var newDest []LogsRequest
	if cap(dest) < len(src) {
		newDest = make([]LogsRequest, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogsRequest(&dest[i], false)
		}
	}
	for i := range src {
		CopyLogsRequest(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLogsRequestPtrSlice(dest, src []*LogsRequest) []*LogsRequest {
	var newDest []*LogsRequest
	if cap(dest) < len(src) {
		newDest = make([]*LogsRequest, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogsRequest()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogsRequest(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogsRequest()
		}
	}
	for i := range src {
		CopyLogsRequest(newDest[i], src[i])
	}
	return newDest
}

func (orig *LogsRequest) Reset() {
	*orig = LogsRequest{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *LogsRequest) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RequestContext != nil {
		dest.WriteObjectField("requestContext")
		orig.RequestContext.MarshalJSON(dest)
	}
	dest.WriteObjectField("logsData")
	orig.LogsData.MarshalJSON(dest)
	if orig.FormatVersion != uint32(0) {
		dest.WriteObjectField("formatVersion")
		dest.WriteUint32(orig.FormatVersion)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *LogsRequest) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "requestContext", "request_context":
			orig.RequestContext = NewRequestContext()
			orig.RequestContext.UnmarshalJSON(iter)
		case "logsData", "logs_data":

			orig.LogsData.UnmarshalJSON(iter)
		case "formatVersion", "format_version":
			orig.FormatVersion = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *LogsRequest) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.LogsData.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.FormatVersion != uint32(0) {
		n += 5
	}
	return n
}

func (orig *LogsRequest) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = orig.LogsData.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x1a

	if orig.FormatVersion != uint32(0) {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.FormatVersion))
		pos--
		buf[pos] = 0xd
	}
	return len(buf) - pos
}

func (orig *LogsRequest) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestContext", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			orig.RequestContext = NewRequestContext()
			err = orig.RequestContext.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LogsData", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.LogsData.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 1:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.FormatVersion = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLogsRequest() *LogsRequest {
	orig := NewLogsRequest()
	orig.RequestContext = GenTestRequestContext()
	orig.LogsData = *GenTestLogsData()
	orig.FormatVersion = uint32(13)
	return orig
}

func GenTestLogsRequestPtrSlice() []*LogsRequest {
	orig := make([]*LogsRequest, 5)
	orig[0] = NewLogsRequest()
	orig[1] = GenTestLogsRequest()
	orig[2] = NewLogsRequest()
	orig[3] = GenTestLogsRequest()
	orig[4] = NewLogsRequest()
	return orig
}

func GenTestLogsRequestSlice() []LogsRequest {
	orig := make([]LogsRequest, 5)
	orig[1] = *GenTestLogsRequest()
	orig[3] = *GenTestLogsRequest()
	return orig
}
