/*
** Copyright (c) 2018-2021 Valve Corporation
** Copyright (c) 2018-2024 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

#ifndef GFXRECON_DECODE_COMMON_OBJECT_TABLE_H
#define GFXRECON_DECODE_COMMON_OBJECT_TABLE_H

#if ENABLE_OPENXR_SUPPORT
#include "generated/generated_openxr_object_info_table.h"
#endif

#include "decode/vulkan_object_info_table.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(decode)

// This class combines all Object info tables into one so that multi-API
// capture can work by allowing various API entrypoints access to all
// available objects.   For example, OpenXR objects will be in a shared
// table with Vulkan objects.

#if ENABLE_OPENXR_SUPPORT
class CommonObjectInfoTable : public VulkanObjectInfoTable, public OpenXrObjectInfoTable
#else
class CommonObjectInfoTable : public VulkanObjectInfoTable
#endif
{
  public:
    static CommonObjectInfoTable* GetSingleton();
    static void                   ReleaseSingleton();

  private:
    static CommonObjectInfoTable* singleton_;
    static uint32_t               singleton_refcount_;
};

GFXRECON_END_NAMESPACE(decode)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif // GFXRECON_DECODE_COMMON_OBJECT_TABLE_H
