import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
const ContextTypes = {
  onAnalyticsEvent: PropTypes.func
};

/**
 * Listens to public and private events and delegates to an analytics
 * stack in a different React root.
 */
// eslint-disable-next-line @repo/internal/react/no-class-components
class AnalyticsDelegate extends Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "onAnalyticsEvent", (name, data, isPrivate) => {
      const {
        delegateAnalyticsEvent
      } = this.props;
      const eventData = {
        ...data
      };
      if (delegateAnalyticsEvent) {
        delegateAnalyticsEvent(name, eventData, isPrivate);
      }
      const {
        onAnalyticsEvent
      } = this.context;
      if (typeof onAnalyticsEvent === 'function') {
        onAnalyticsEvent(name, data, isPrivate);
      }
    });
  }
  getChildContext() {
    return {
      onAnalyticsEvent: this.onAnalyticsEvent
    };
  }
  render() {
    const {
      children
    } = this.props;
    return React.Children.only(children);
  }
}
_defineProperty(AnalyticsDelegate, "contextTypes", ContextTypes);
_defineProperty(AnalyticsDelegate, "childContextTypes", ContextTypes);
export default AnalyticsDelegate;