import React, { Component } from 'react';
import PropTypes from 'prop-types';
type AnalyticsDelegateProps = {
    delegateAnalyticsEvent?: (name: string, data: any, isPrivate: boolean) => void;
    children: React.ReactNode;
};
type AnalyticsDelegateContext = {
    onAnalyticsEvent?: (name: string, data: any, isPrivate: boolean) => void;
};
/**
 * Listens to public and private events and delegates to an analytics
 * stack in a different React root.
 */
declare class AnalyticsDelegate extends Component<AnalyticsDelegateProps> {
    static contextTypes: {
        onAnalyticsEvent: PropTypes.Requireable<(...args: any[]) => any>;
    };
    static childContextTypes: {
        onAnalyticsEvent: PropTypes.Requireable<(...args: any[]) => any>;
    };
    getChildContext(): AnalyticsDelegateContext;
    onAnalyticsEvent: (name: string, data: any, isPrivate: boolean) => void;
    render(): React.ReactNode;
}
export default AnalyticsDelegate;
