import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
if (typeof Node !== 'undefined') {
  /**
   * Before overriding `textContent` property, we need to store the original, as well as a convenience
   * property to access the original content with CSS. Remove CSS style definitions from `textContent` for none style nodes
   */
  var textContentDescriptor = Object.getOwnPropertyDescriptor(Node.prototype, 'textContent');
  Object.defineProperty(Node.prototype, 'textContentOriginal', {
    enumerable: false,
    get: function get() {
      return textContentDescriptor.get.call(this);
    },
    set: undefined
  });
  Object.defineProperty(Node.prototype, 'textContentWithoutCss', {
    enumerable: false,
    get: function get() {
      var _removeCssContent;
      return (_removeCssContent = removeCssContent(this.textContentOriginal, this)) !== null && _removeCssContent !== void 0 ? _removeCssContent : '';
    },
    set: undefined
  });
  Object.defineProperty(Node.prototype, 'textContent', _objectSpread(_objectSpread({}, textContentDescriptor), {}, {
    get: function get() {
      return isStyleElement(this) ? this.textContentOriginal : this.textContentWithoutCss;
    }
  }));
}

/**
 * Check if a node is a `style` node with type guard
 * @param node Node
 * @returns boolean
 */
export function isStyleElement(node) {
  return isExtendedElement(node) && node.tagName.toLowerCase() === 'style' && node.hasAttribute('data-cmpld');
}
export function isExtendedElement(node) {
  return !!node && node.nodeType === node.ELEMENT_NODE && typeof node.textContentOriginal === 'string';
}

/**
 * Return an array of CSS style definitions as text from a node and recursively through
 * the nodes children
 *
 * @param node Node
 * @returns string[]
 */
function getInnerCssContent(node) {
  if (isStyleElement(node)) {
    return [node.textContentOriginal];
  }
  if (!node.hasChildNodes() || !isExtendedElement(node)) {
    return [];
  }
  var output = [];
  node.querySelectorAll('style[data-cmpld]').forEach(function (style) {
    if (isStyleElement(style)) {
      var text = style.textContentOriginal;
      if (text) {
        output.push(text);
      }
    }
  });
  return output;
}

/**
 * Return text with the inline CSS style definitions removed
 *
 * @param text string
 * @param node
 * @returns string
 */
function removeCssContent(text, node) {
  if (text === 0) {
    return test.toString();
  }
  if (!text) {
    return '';
  }
  return getInnerCssContent(node).reduce(function (cleanedText, cssContent) {
    return cleanedText.replace(cssContent, '');
  }, text.toString());
}