import { type DataAdapterAsyncOptions, DataAdapterCore, type DataAdapterResult, type EvaluationsDataAdapter, type StatsigUser, type StatsigUserInternal } from '@statsig/js-client';
/**
 * Data adapter which only uses bootstrap data and will never fetch from network or cache.
 * We do this because we control the fetching of bootstrap data from FFS in Client.ts whereas the
 * default data adapter fetches from Statsig servers.
 */
export declare class NoFetchDataAdapter extends DataAdapterCore implements EvaluationsDataAdapter {
    bootstrapResult: DataAdapterResult | null;
    constructor();
    /**
     * Make sure to call this **before** calling `initializeAsync` or `updateUserAsync` but
     * after the Statsig client has been created!
     */
    setBootstrapData(data?: Record<string, unknown>): void;
    prefetchData(_user: StatsigUser, _options?: DataAdapterAsyncOptions | undefined): Promise<void>;
    getDataAsync(_current: DataAdapterResult | null, user: StatsigUser, _options?: DataAdapterAsyncOptions | undefined): Promise<DataAdapterResult | null>;
    getDataSync(user?: StatsigUser | undefined): DataAdapterResult | null;
    protected _fetchFromNetwork(_current: string | null, _user?: StatsigUser | undefined, _options?: DataAdapterAsyncOptions | undefined): Promise<string | null>;
    protected _getCacheKey(user?: StatsigUserInternal | undefined): string;
    protected _isCachedResultValidFor204(_result: DataAdapterResult, _user: StatsigUser | undefined): boolean;
    setDataLegacy(data: string, user: StatsigUser): void;
    toJSON(): Record<string, unknown>;
}
