import { getRect } from 'css-box-model';
import getMaxWindowScroll from './get-max-window-scroll';
import getWindowScroll from './get-window-scroll';
export default (function () {
  var scroll = getWindowScroll();
  var maxScroll = getMaxWindowScroll();
  var top = scroll.y;
  var left = scroll.x;

  // window.innerHeight: includes scrollbars (not what we want)
  // document.clientHeight gives us the correct value when using the html5 doctype
  var doc = document.documentElement;
  // Using these values as they do not consider scrollbars
  // padding box, without scrollbar
  var width = doc.clientWidth;
  var height = doc.clientHeight;

  // Computed
  var right = left + width;
  var bottom = top + height;
  var container = getRect({
    top: top,
    left: left,
    right: right,
    bottom: bottom
  });
  var viewport = {
    container: container,
    scroll: {
      current: scroll,
      max: maxScroll
    }
  };
  return viewport;
});