"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDraggableStateSnapshot = useDraggableStateSnapshot;
var _react = require("react");
function useDraggableStateSnapshot(_ref) {
  var draggingOver = _ref.draggingOver,
    isClone = _ref.isClone,
    isDragging = _ref.isDragging,
    mode = _ref.mode;
  return (0, _react.useMemo)(function () {
    return {
      isClone: isClone,
      isDragging: isDragging,
      draggingOver: draggingOver,
      mode: mode,
      /**
       * The properties below are fixed in the migration layer,
       * because they are not supported.
       *
       * Animation and combination were intentionally removed.
       */
      isDropAnimating: false,
      dropAnimation: null,
      combineWith: null,
      combineTargetFor: null
    };
  }, [draggingOver, isClone, isDragging, mode]);
}