"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DroppableContextProvider = void 0;
exports.useDroppableContext = useDroppableContext;
exports.useParentDroppableId = useParentDroppableId;
var _react = require("react");
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
var DroppableContext = /*#__PURE__*/(0, _react.createContext)(null);
var DroppableContextProvider = exports.DroppableContextProvider = DroppableContext.Provider;

/**
 * Intended for use by `<Draggable>` instances.
 */
function useDroppableContext() {
  var value = (0, _react.useContext)(DroppableContext);
  (0, _rbdInvariant.rbdInvariant)(value, 'Missing <Droppable /> parent');
  return value;
}

/**
 * Returns the `droppableId` of the parent droppable, if there is one.
 *
 * Intended for use only by `<Droppable>` instances.
 */
function useParentDroppableId() {
  var parentDroppable = (0, _react.useContext)(DroppableContext);
  if (!parentDroppable) {
    return null;
  }
  return parentDroppable.droppableId;
}