/**
 * This file is ported almost exactly from `react-beautiful-dnd`.
 *
 * In `react-beautiful-dnd` it is relevant to all drags,
 * but in the migration layer it is only relevant to keyboard drags.
 *
 * This is because now the browser is responsible for determining when a
 * pointer drag can occur.
 */
export type TagNameMap = {
    [tagName: string]: true;
};
export declare const interactiveTagNames: TagNameMap;
export declare function isAnInteractiveElement(parent: Element, current: Element | null): boolean;
export default function isEventInInteractiveElement(draggable: Element, event: Event): boolean;
