/* grid.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./grid.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var rowGapMap = {
  'space.0': "_1p57ze3t",
  'space.025': "_1p57v77o",
  'space.050': "_1p571b66",
  'space.075': "_1p5712x7",
  'space.100': "_1p57u2gc",
  'space.150': "_1p57utpp",
  'space.200': "_1p57pxbi",
  'space.250': "_1p57v47k",
  'space.300': "_1p571ejb",
  'space.400': "_1p57xy5q",
  'space.500': "_1p571jfw",
  'space.600': "_1p57oahv",
  'space.800': "_1p57xncg",
  'space.1000': "_1p571epz"
};
var columnGapMap = {
  'space.0': "_gy1pze3t",
  'space.025': "_gy1pv77o",
  'space.050': "_gy1p1b66",
  'space.075': "_gy1p12x7",
  'space.100': "_gy1pu2gc",
  'space.150': "_gy1putpp",
  'space.200': "_gy1ppxbi",
  'space.250': "_gy1pv47k",
  'space.300': "_gy1p1ejb",
  'space.400': "_gy1pxy5q",
  'space.500': "_gy1p1jfw",
  'space.600': "_gy1poahv",
  'space.800': "_gy1pxncg",
  'space.1000': "_gy1p1epz"
};
var justifyContentMap = {
  start: "_1bahv2br",
  center: "_1bah1h6o",
  end: "_1bahh9n0",
  'space-between': "_1bah1yb4",
  'space-around': "_1bah1b1v",
  'space-evenly': "_1bahitcz",
  stretch: "_1bah1fhb"
};
var alignContentMap = {
  start: "_ae4vv2br",
  center: "_ae4v1h6o",
  end: "_ae4vh9n0",
  'space-between': "_ae4v1yb4",
  'space-around': "_ae4v1b1v",
  'space-evenly': "_ae4vitcz",
  stretch: "_ae4v1fhb"
};
var alignItemsMap = {
  start: "_4cvrv2br",
  center: "_4cvr1h6o",
  baseline: "_4cvr1q9y",
  end: "_4cvrh9n0",
  stretch: "_4cvr1fhb"
};
var baseStyles = {
  root: "_1e0c11p5 _vchhusvi"
};
var gridAutoFlowMap = {
  row: "_wij2vrvc",
  column: "_wij21bp4",
  dense: "_wij218l3",
  'row dense': "_wij2j5tq",
  'column dense': "_wij2adhi"
};

/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
var Grid = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignItems,
    alignContent = _ref.alignContent,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    id = _ref.id,
    role = _ref.role,
    testId = _ref.testId,
    autoFlow = _ref.autoFlow,
    xcss = _ref.xcss;
  var Component = as || 'div';
  return /*#__PURE__*/React.createElement(Component, {
    id: id,
    role: role,
    className: (0, _runtime.ax)([baseStyles.root, gap && columnGapMap[gap], columnGap && columnGapMap[columnGap], gap && rowGapMap[gap], rowGap && rowGapMap[rowGap], alignItems && alignItemsMap[alignItems], alignContent && alignContentMap[alignContent], justifyContent && justifyContentMap[justifyContent], autoFlow && gridAutoFlowMap[autoFlow], xcss]),
    "data-testid": testId,
    ref: ref
  }, children);
}));
Grid.displayName = 'Grid';
var _default = exports.default = Grid;