/* inline.tsx generated by @compiled/babel-plugin v0.36.1 */
import "./inline.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
import { Children, forwardRef, Fragment, memo } from 'react';
import { cx } from '@atlaskit/css';
import Flex from './flex';
const styles = {
  separator: "_1mouze3t _195g1i6y _syazjjyb _lcxvglyw _uiztglyw",
  hug: "_16jlidpf",
  fill: "_1bsb1osq _16jlkb7n"
};
const Separator = ({
  children
}) => /*#__PURE__*/React.createElement("span", {
  className: ax([styles.separator])
}, children);

/**
 * __Inline__
 *
 * Inline is a primitive component based on CSS Flexbox that manages the horizontal layout of direct children.
 *
 * @example
 * ```tsx
 *  <Inline>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *    <Box padding="space.100" backgroundColor="neutral"></Box>
 *  </Inline>
 * ```
 *
 */
const Inline = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(({
  as,
  alignInline,
  alignBlock: alignItems = 'start',
  shouldWrap = false,
  spread,
  grow,
  space,
  rowSpace,
  separator,
  xcss,
  testId,
  role,
  children: rawChildren
}, ref) => {
  const separatorComponent = typeof separator === 'string' ? /*#__PURE__*/React.createElement(Separator, null, separator) : separator;
  const children = separatorComponent ? Children.toArray(rawChildren).filter(Boolean).map((child, index) => {
    return /*#__PURE__*/React.createElement(Fragment, {
      key: index
    }, separator && index > 0 ? separatorComponent : null, child);
  }) : rawChildren;
  return /*#__PURE__*/React.createElement(Flex, {
    as: as,
    role: role,
    alignItems: alignItems,
    justifyContent: spread || alignInline,
    direction: "row",
    gap: space,
    rowGap: rowSpace,
    wrap: shouldWrap ? 'wrap' : undefined,
    xcss: cx(grow === 'hug' && styles.hug, grow === 'fill' && styles.fill, xcss),
    testId: testId,
    ref: ref
  }, children);
}));
Inline.displayName = 'Inline';
export default Inline;