import _defineProperty from "@babel/runtime/helpers/defineProperty";
/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { forwardRef, memo, useMemo } from 'react';

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css, jsx } from '@emotion/react';
import { spaceStylesMap } from '../xcss/style-maps.partial';
import { parseXcss } from '../xcss/xcss';
var gridTemplateAreasVar = '--ds-grid--grid-template-areas';
var gridTemplateColumnsVar = '--ds-grid--grid-template-columns';
var gridTemplateRowsVar = '--ds-grid--grid-template-rows';
var justifyContentMap = {
  start: css({
    justifyContent: 'start'
  }),
  center: css({
    justifyContent: 'center'
  }),
  end: css({
    justifyContent: 'end'
  }),
  'space-between': css({
    justifyContent: 'space-between'
  }),
  'space-around': css({
    justifyContent: 'space-around'
  }),
  'space-evenly': css({
    justifyContent: 'space-evenly'
  }),
  stretch: css({
    justifyContent: 'stretch'
  })
};
var justifyItemsMap = {
  start: css({
    justifyItems: 'start'
  }),
  center: css({
    justifyItems: 'center'
  }),
  end: css({
    justifyItems: 'end'
  }),
  stretch: css({
    justifyItems: 'stretch'
  })
};
var alignContentMap = {
  start: css({
    alignContent: 'start'
  }),
  center: css({
    alignContent: 'center'
  }),
  end: css({
    alignContent: 'end'
  }),
  'space-between': css({
    alignContent: 'space-between'
  }),
  'space-around': css({
    alignContent: 'space-around'
  }),
  'space-evenly': css({
    alignContent: 'space-evenly'
  }),
  stretch: css({
    alignContent: 'stretch'
  })
};
var alignItemsMap = {
  start: css({
    alignItems: 'start'
  }),
  center: css({
    alignItems: 'center'
  }),
  baseline: css({
    alignItems: 'baseline'
  }),
  end: css({
    alignItems: 'end'
  })
};
var baseStyles = css({
  display: 'grid',
  boxSizing: 'border-box',
  gridTemplateAreas: "var(".concat(gridTemplateAreasVar, ")"),
  gridTemplateColumns: "var(".concat(gridTemplateColumnsVar, ")"),
  gridTemplateRows: "var(".concat(gridTemplateRowsVar, ")")
});
var gridAutoFlowMap = {
  row: css({
    gridAutoFlow: 'row'
  }),
  column: css({
    gridAutoFlow: 'column'
  }),
  dense: css({
    gridAutoFlow: 'dense'
  }),
  'row dense': css({
    gridAutoFlow: 'row dense'
  }),
  'column dense': css({
    gridAutoFlow: 'column dense'
  })
};

/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
var Grid = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var as = _ref.as,
    alignItems = _ref.alignItems,
    alignContent = _ref.alignContent,
    justifyContent = _ref.justifyContent,
    gap = _ref.gap,
    columnGap = _ref.columnGap,
    rowGap = _ref.rowGap,
    children = _ref.children,
    id = _ref.id,
    role = _ref.role,
    testId = _ref.testId,
    autoFlow = _ref.autoFlow,
    gridTemplateAreas = _ref.templateAreas,
    gridTemplateRows = _ref.templateRows,
    gridTemplateColumns = _ref.templateColumns,
    xcss = _ref.xcss;
  var Component = as || 'div';
  var resolvedStyles = parseXcss(xcss);

  /**
   * We use CSS variables to allow for dynamic grid templates instead of dynamically setting to `props.style`
   * This allows `props.xcss` to override them as `style={{ gridTemplateAreas }}` would have higher specificity.
   *
   * This must be reset to `initial` if `gridTemplateAreas` is not set, otherwise nested grids will break!
   *
   * NOTE: If we disallow `grid-template-areas` (etc) to be set via `props.xcss`, we can remove this.
   */
  var style = useMemo(function () {
    return _defineProperty(_defineProperty(_defineProperty({}, gridTemplateAreasVar, gridTemplateAreas ? gridTemplateAreas.map(function (str) {
      return "\"".concat(str, "\"");
    }).join('\n') || 'initial' : 'initial'), gridTemplateColumnsVar, gridTemplateColumns || 'initial'), gridTemplateRowsVar, gridTemplateRows || 'initial');
  }, [gridTemplateAreas, gridTemplateColumns, gridTemplateRows]);
  return jsx(Component, {
    id: id,
    role: role
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- Ignored via go/DSP-18766
    ,
    style: style
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    ,
    className: resolvedStyles.static,
    css: [baseStyles,
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    gap && spaceStylesMap.gap[gap],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    columnGap && spaceStylesMap.columnGap[columnGap],
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    rowGap && spaceStylesMap.rowGap[rowGap], alignItems && alignItemsMap[alignItems], alignContent && alignContentMap[alignContent], justifyContent && justifyContentMap[justifyContent], autoFlow && gridAutoFlowMap[autoFlow], resolvedStyles.emotion],
    "data-testid": testId,
    ref: ref
  }, children);
}));
Grid.displayName = 'Grid';
export default Grid;