import { createContext, useContext } from 'react';
/**
 * __Surface context__
 *
 * A surface context provides context information on the current background (if set).
 */
export var SurfaceContext = /*#__PURE__*/createContext('elevation.surface');

/**
 * __useSurface__
 *
 * Return the current surface. If no parent sets a surface color it falls back to the default surface.
 *
 * @see SurfaceContext
 */
export var useSurface = function useSurface() {
  return useContext(SurfaceContext);
};
SurfaceContext.displayName = 'SurfaceProvider';