/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ComponentPropsWithRef, type ElementType, type ReactNode } from 'react';
import { type TextColor, type TextSize, type TextWeight } from '../xcss/style-maps.partial';
import type { BasePrimitiveProps } from './types';
declare const asAllowlist: readonly ["span", "p", "strong", "em"];
type AsElement = (typeof asAllowlist)[number];
type TextPropsBase<T extends ElementType = 'span'> = {
    /**
     * HTML tag to be rendered. Defaults to `span`.
     */
    as?: AsElement;
    /**
     * Elements rendered within the Text element.
     */
    children: ReactNode;
    /**
     * Token representing text color with a built-in fallback value.
     * Will apply inverse text color automatically if placed within a Box with bold background color.
     * Defaults to `color.text` if not nested in other Text components.
     */
    color?: TextColor | 'inherit';
    /**
     * The [HTML `id` attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/id).
     */
    id?: string;
    /**
     * The number of lines to limit the provided text to. Text will be truncated with an ellipsis.
     *
     * When `maxLines={1}`, `wordBreak` defaults to `break-all` to match the behaviour of `text-overflow: ellipsis`.
     */
    maxLines?: number;
    /**
     * Text alignment.
     */
    align?: TextAlign;
    /**
     * Text size.
     */
    size?: TextSize;
    /**
     * Font weight.
     */
    weight?: TextWeight;
    /**
     * Forwarded ref.
     */
    ref?: ComponentPropsWithRef<T>['ref'];
};
export type TextProps<T extends ElementType = 'span'> = TextPropsBase<T> & Omit<BasePrimitiveProps, 'xcss'>;
type TextAlign = keyof typeof textAlignMap;
declare const textAlignMap: {
    center: import("@emotion/react").SerializedStyles;
    end: import("@emotion/react").SerializedStyles;
    start: import("@emotion/react").SerializedStyles;
};
/**
 * __Text__
 *
 * Text is a primitive component that has the Atlassian Design System's design guidelines baked in.
 * This includes considerations for text attributes such as color, font size, font weight, and line height.
 * It renders a `span` by default.
 *
 * @internal
 */
declare const Text: import("react").ForwardRefExoticComponent<Omit<TextProps<ElementType>, "ref"> & import("react").RefAttributes<any>>;
export default Text;
