/* visually-hidden.tsx generated by @compiled/babel-plugin v0.36.1 */
import "./visually-hidden.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
const visuallyHiddenStyles = null;

/**
 * __Visually hidden__
 *
 * A composable element to apply a visually hidden effect to children.
 * Useful for accessibility compliance.
 *
 * @example
 * ```jsx
 * import VisuallyHidden from '@atlaskit/visually-hidden';
 *
 * export default () => (
 *   <div style={{ border: '1px solid black' }}>
 *      There is text hidden between the brackets [
 *      <VisuallyHidden>Can't see me!</VisuallyHidden>]
 *   </div>
 * );
 * ```
 */
const VisuallyHidden = ({
  children,
  testId,
  role,
  id
}) => {
  return /*#__PURE__*/React.createElement("span", {
    id: id,
    "data-testid": testId,
    role: role,
    className: ax(["_ca0qidpf _u5f3idpf _n3tdidpf _19bvidpf _19itidpf _1reo15vq _18m915vq _1bsbt94y _4t3it94y _kqswstnw _ogto7mnp _uiztglyw _o5721q9c"])
  }, children);
};
export default VisuallyHidden;