import { TButtonProps } from "../Form";
import { EStatus } from "../../genericTypes";
import { TInformationListProps } from "../InformationList";
import { ReactNode } from "react";
type TConfirmationDialogBodyProps = {
    text?: string;
    content?: ReactNode;
    cancelButtonText: string;
    confirmationButtonText: string;
    confirmationButtonVariant?: TButtonProps["variant"];
    information?: {
        key: string;
        value: ReactNode;
    }[];
    gridListProps?: Omit<TInformationListProps, "items">;
    onSubmit: () => void;
    onClose: () => void;
    alertStatus?: EStatus;
};
type TConfirmationDialogProps = TConfirmationDialogBodyProps & {
    opened: boolean;
    closeOnEscape?: boolean;
    closeOnClickOutside?: boolean;
    title: string;
};
declare const ConfirmationDialogBody: ({ text, content, onSubmit, onClose, cancelButtonText, confirmationButtonText, confirmationButtonVariant, information, gridListProps, alertStatus, }: TConfirmationDialogBodyProps) => import("react/jsx-runtime").JSX.Element;
declare const ConfirmationDialog: ({ title, opened, onClose, closeOnEscape, closeOnClickOutside, ...bodyProps }: TConfirmationDialogProps) => import("react/jsx-runtime").JSX.Element;
export { ConfirmationDialog, ConfirmationDialogBody };
//# sourceMappingURL=ConfirmationDialog.d.ts.map