import { RefObject } from "react";
import { TFilter } from "../types";
import { TUpdateTerms } from "./types";
export declare const DEFAULT_FILTER_STATE: TFilter.Internal.State;
type TFilterStateContext = TFilterContextProviderProps & {
    state: TFilter.Internal.State;
    setState: React.Dispatch<TFilter.Internal.State>;
};
declare const FilterContext: import("react").Context<TFilterStateContext>;
type TFilterContextProviderProps = {
    onApply: TFilter.EventHandler.onApply;
    config: TFilter.Config;
    initialState?: TFilter.Internal.State;
    portalTargetRef: RefObject<HTMLDivElement> | null;
    transformer?: {
        dtoValueTransformMap?: TFilter.DTO.ValueTransformConfigByAttributeName;
    };
};
export declare const FilterContextProvider: React.FC<React.PropsWithChildren<TFilterContextProviderProps>>;
declare const useFilter: () => {
    deleteTerm: (id: number) => void;
    deleteAllTerms: () => void;
    removeUncompletedTerms: () => void;
    updateTerm: (args: TFilter.Internal.Term.State, addNewTerm?: boolean) => void;
    pushEmptyTerm: () => void;
    state: TFilter.Internal.State;
    onApply: TFilter.EventHandler.onApply;
    setState: import("react").Dispatch<TFilter.Internal.State>;
    deactivateAllTerms: () => void;
    config: TFilter.Config;
    updateMatch: (newMatch: TFilter.Internal.Match) => void;
    toggleTermsCollapsed: (value?: boolean) => void;
    updateTerms: TUpdateTerms;
    portalTargetRef: RefObject<HTMLDivElement> | null;
    transformer: {
        dtoValueTransformMap?: TFilter.DTO.ValueTransformConfigByAttributeName;
    } | undefined;
};
declare const useFilterTerm: (id: number) => {
    term: TFilter.Internal.Term.State | undefined;
    handleBlur: () => void;
    updateCurrentTerm: (update: TFilter.Internal.Term.State, addNewTerm?: boolean) => void;
    deleteCurrentTerm: () => void;
    setCurrentTermActive: () => void;
    handleValueChange: (value: TFilter.Internal.Term.TermValue, addNewTerm?: boolean) => void;
};
export { FilterContext, useFilterTerm, useFilter };
//# sourceMappingURL=useFilter.d.ts.map