'use client';
import 'dayjs';
import { shiftTimezone } from '../../../utils/shift-timezone.mjs';

function dateStringParser(dateString, timezone) {
  if (dateString === null) {
    return null;
  }
  const date = shiftTimezone("add", new Date(dateString), timezone);
  if (Number.isNaN(date.getTime()) || !dateString) {
    return null;
  }
  return date;
}

export { dateStringParser };
//# sourceMappingURL=date-string-parser.mjs.map
