
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPrintPreviewWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPrintPreviewWidget>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QPrinter>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPrintPreviewWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPrintPreviewWidget::staticMetaObject);
}


// int QPrintPreviewWidget::currentPage()


static void _init_f_currentPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentPage_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->currentPage ());
}


// void QPrintPreviewWidget::fitInView()


static void _init_f_fitInView_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_fitInView_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->fitInView ();
}


// void QPrintPreviewWidget::fitToWidth()


static void _init_f_fitToWidth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_fitToWidth_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->fitToWidth ();
}


// int QPrintPreviewWidget::numPages()


static void _init_f_numPages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_numPages_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->numPages ());
}


// QPrinter::Orientation QPrintPreviewWidget::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrinter::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrinter::Orientation>::target_type > ((qt_gsi::Converter<QPrinter::Orientation>::target_type)qt_gsi::CppToQtAdaptor<QPrinter::Orientation>(((QPrintPreviewWidget *)cls)->orientation ()));
}


// int QPrintPreviewWidget::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPrintPreviewWidget *)cls)->pageCount ());
}


// void QPrintPreviewWidget::print()


static void _init_f_print_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_print_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->print ();
}


// void QPrintPreviewWidget::setAllPagesViewMode()


static void _init_f_setAllPagesViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setAllPagesViewMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setAllPagesViewMode ();
}


// void QPrintPreviewWidget::setCurrentPage(int pageNumber)


static void _init_f_setCurrentPage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentPage_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setCurrentPage (arg1);
}


// void QPrintPreviewWidget::setFacingPagesViewMode()


static void _init_f_setFacingPagesViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setFacingPagesViewMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setFacingPagesViewMode ();
}


// void QPrintPreviewWidget::setLandscapeOrientation()


static void _init_f_setLandscapeOrientation_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setLandscapeOrientation_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setLandscapeOrientation ();
}


// void QPrintPreviewWidget::setOrientation(QPrinter::Orientation orientation)


static void _init_f_setOrientation_2537 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<QPrinter::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_2537 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrinter::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrinter::Orientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<QPrinter::Orientation>(arg1).cref());
}


// void QPrintPreviewWidget::setPortraitOrientation()


static void _init_f_setPortraitOrientation_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setPortraitOrientation_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setPortraitOrientation ();
}


// void QPrintPreviewWidget::setSinglePageViewMode()


static void _init_f_setSinglePageViewMode_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setSinglePageViewMode_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setSinglePageViewMode ();
}


// void QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode viewMode)


static void _init_f_setViewMode_3308 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewMode");
  decl->add_arg<const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewMode_3308 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setViewMode (qt_gsi::QtToCppAdaptor<QPrintPreviewWidget::ViewMode>(arg1).cref());
}


// void QPrintPreviewWidget::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setVisible (arg1);
}


// void QPrintPreviewWidget::setZoomFactor(double zoomFactor)


static void _init_f_setZoomFactor_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoomFactor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZoomFactor_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setZoomFactor (arg1);
}


// void QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode zoomMode)


static void _init_f_setZoomMode_3318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoomMode");
  decl->add_arg<const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZoomMode_3318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->setZoomMode (qt_gsi::QtToCppAdaptor<QPrintPreviewWidget::ZoomMode>(arg1).cref());
}


// void QPrintPreviewWidget::updatePreview()


static void _init_f_updatePreview_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_updatePreview_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->updatePreview ();
}


// QPrintPreviewWidget::ViewMode QPrintPreviewWidget::viewMode()


static void _init_f_viewMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type > ();
}

static void _call_f_viewMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type > ((qt_gsi::Converter<QPrintPreviewWidget::ViewMode>::target_type)qt_gsi::CppToQtAdaptor<QPrintPreviewWidget::ViewMode>(((QPrintPreviewWidget *)cls)->viewMode ()));
}


// double QPrintPreviewWidget::zoomFactor()


static void _init_f_zoomFactor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_zoomFactor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QPrintPreviewWidget *)cls)->zoomFactor ());
}


// void QPrintPreviewWidget::zoomIn(double zoom)


static void _init_f_zoomIn_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoom", true, "1.1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomIn_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->zoomIn (arg1);
}


// QPrintPreviewWidget::ZoomMode QPrintPreviewWidget::zoomMode()


static void _init_f_zoomMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type > ();
}

static void _call_f_zoomMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type > ((qt_gsi::Converter<QPrintPreviewWidget::ZoomMode>::target_type)qt_gsi::CppToQtAdaptor<QPrintPreviewWidget::ZoomMode>(((QPrintPreviewWidget *)cls)->zoomMode ()));
}


// void QPrintPreviewWidget::zoomOut(double zoom)


static void _init_f_zoomOut_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zoom", true, "1.1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomOut_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args ? gsi::arg_reader<double >() (args, heap) : gsi::arg_maker<double >() (1.1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget *)cls)->zoomOut (arg1);
}


// static QString QPrintPreviewWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPrintPreviewWidget::tr (arg1, arg2));
}


// static QString QPrintPreviewWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPrintPreviewWidget::tr (arg1, arg2, arg3));
}


// static QString QPrintPreviewWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QPrintPreviewWidget::trUtf8 (arg1, arg2));
}


// static QString QPrintPreviewWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QPrintPreviewWidget::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QPrintPreviewWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":currentPage", "@brief Method int QPrintPreviewWidget::currentPage()\n", true, &_init_f_currentPage_c0, &_call_f_currentPage_c0);
  methods += new qt_gsi::GenericMethod ("fitInView", "@brief Method void QPrintPreviewWidget::fitInView()\n", false, &_init_f_fitInView_0, &_call_f_fitInView_0);
  methods += new qt_gsi::GenericMethod ("fitToWidth", "@brief Method void QPrintPreviewWidget::fitToWidth()\n", false, &_init_f_fitToWidth_0, &_call_f_fitToWidth_0);
  methods += new qt_gsi::GenericMethod ("numPages", "@brief Method int QPrintPreviewWidget::numPages()\n", true, &_init_f_numPages_c0, &_call_f_numPages_c0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method QPrinter::Orientation QPrintPreviewWidget::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Method int QPrintPreviewWidget::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
  methods += new qt_gsi::GenericMethod ("print", "@brief Method void QPrintPreviewWidget::print()\n", false, &_init_f_print_0, &_call_f_print_0);
  methods += new qt_gsi::GenericMethod ("setAllPagesViewMode", "@brief Method void QPrintPreviewWidget::setAllPagesViewMode()\n", false, &_init_f_setAllPagesViewMode_0, &_call_f_setAllPagesViewMode_0);
  methods += new qt_gsi::GenericMethod ("setCurrentPage|currentPage=", "@brief Method void QPrintPreviewWidget::setCurrentPage(int pageNumber)\n", false, &_init_f_setCurrentPage_767, &_call_f_setCurrentPage_767);
  methods += new qt_gsi::GenericMethod ("setFacingPagesViewMode", "@brief Method void QPrintPreviewWidget::setFacingPagesViewMode()\n", false, &_init_f_setFacingPagesViewMode_0, &_call_f_setFacingPagesViewMode_0);
  methods += new qt_gsi::GenericMethod ("setLandscapeOrientation", "@brief Method void QPrintPreviewWidget::setLandscapeOrientation()\n", false, &_init_f_setLandscapeOrientation_0, &_call_f_setLandscapeOrientation_0);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QPrintPreviewWidget::setOrientation(QPrinter::Orientation orientation)\n", false, &_init_f_setOrientation_2537, &_call_f_setOrientation_2537);
  methods += new qt_gsi::GenericMethod ("setPortraitOrientation", "@brief Method void QPrintPreviewWidget::setPortraitOrientation()\n", false, &_init_f_setPortraitOrientation_0, &_call_f_setPortraitOrientation_0);
  methods += new qt_gsi::GenericMethod ("setSinglePageViewMode", "@brief Method void QPrintPreviewWidget::setSinglePageViewMode()\n", false, &_init_f_setSinglePageViewMode_0, &_call_f_setSinglePageViewMode_0);
  methods += new qt_gsi::GenericMethod ("setViewMode|viewMode=", "@brief Method void QPrintPreviewWidget::setViewMode(QPrintPreviewWidget::ViewMode viewMode)\n", false, &_init_f_setViewMode_3308, &_call_f_setViewMode_3308);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QPrintPreviewWidget::setVisible(bool visible)\nThis is a reimplementation of QWidget::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setZoomFactor|zoomFactor=", "@brief Method void QPrintPreviewWidget::setZoomFactor(double zoomFactor)\n", false, &_init_f_setZoomFactor_1071, &_call_f_setZoomFactor_1071);
  methods += new qt_gsi::GenericMethod ("setZoomMode|zoomMode=", "@brief Method void QPrintPreviewWidget::setZoomMode(QPrintPreviewWidget::ZoomMode zoomMode)\n", false, &_init_f_setZoomMode_3318, &_call_f_setZoomMode_3318);
  methods += new qt_gsi::GenericMethod ("updatePreview", "@brief Method void QPrintPreviewWidget::updatePreview()\n", false, &_init_f_updatePreview_0, &_call_f_updatePreview_0);
  methods += new qt_gsi::GenericMethod (":viewMode", "@brief Method QPrintPreviewWidget::ViewMode QPrintPreviewWidget::viewMode()\n", true, &_init_f_viewMode_c0, &_call_f_viewMode_c0);
  methods += new qt_gsi::GenericMethod (":zoomFactor", "@brief Method double QPrintPreviewWidget::zoomFactor()\n", true, &_init_f_zoomFactor_c0, &_call_f_zoomFactor_c0);
  methods += new qt_gsi::GenericMethod ("zoomIn", "@brief Method void QPrintPreviewWidget::zoomIn(double zoom)\n", false, &_init_f_zoomIn_1071, &_call_f_zoomIn_1071);
  methods += new qt_gsi::GenericMethod (":zoomMode", "@brief Method QPrintPreviewWidget::ZoomMode QPrintPreviewWidget::zoomMode()\n", true, &_init_f_zoomMode_c0, &_call_f_zoomMode_c0);
  methods += new qt_gsi::GenericMethod ("zoomOut", "@brief Method void QPrintPreviewWidget::zoomOut(double zoom)\n", false, &_init_f_zoomOut_1071, &_call_f_zoomOut_1071);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QPrintPreviewWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPrintPreviewWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QPrinter * > ("paintRequested(QPrinter *)", "paintRequested", gsi::arg("printer"), "@brief Signal declaration for QPrintPreviewWidget::paintRequested(QPrinter *printer)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("previewChanged()", "previewChanged", "@brief Signal declaration for QPrintPreviewWidget::previewChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPrintPreviewWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPrintPreviewWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QPrintPreviewWidget> decl_QPrintPreviewWidget (qtdecl_QWidget (), "QtGui", "QPrintPreviewWidget_Native",
  methods_QPrintPreviewWidget (),
  "@hide\n@alias QPrintPreviewWidget");

GSI_QTGUI_PUBLIC gsi::Class<QPrintPreviewWidget> &qtdecl_QPrintPreviewWidget () { return decl_QPrintPreviewWidget; }

}


class QPrintPreviewWidget_Adaptor : public QPrintPreviewWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPrintPreviewWidget_Adaptor();

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer) : QPrintPreviewWidget(printer)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer, QWidget *parent) : QPrintPreviewWidget(printer, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(printer, parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor() : QPrintPreviewWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QWidget *parent) : QPrintPreviewWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)
  QPrintPreviewWidget_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QPrintPreviewWidget(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QPrintPreviewWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QPrintPreviewWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QPrintPreviewWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QPrintPreviewWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QPrintPreviewWidget::focusNextChild()
  bool fp_QPrintPreviewWidget_focusNextChild_0 () {
    return QPrintPreviewWidget::focusNextChild();
  }

  //  [expose] bool QPrintPreviewWidget::focusPreviousChild()
  bool fp_QPrintPreviewWidget_focusPreviousChild_0 () {
    return QPrintPreviewWidget::focusPreviousChild();
  }

  //  [expose] int QPrintPreviewWidget::receivers(const char *signal)
  int fp_QPrintPreviewWidget_receivers_c1731 (const char *signal) const {
    return QPrintPreviewWidget::receivers(signal);
  }

  //  [expose] void QPrintPreviewWidget::resetInputContext()
  void fp_QPrintPreviewWidget_resetInputContext_0 () {
    QPrintPreviewWidget::resetInputContext();
  }

  //  [expose] QObject *QPrintPreviewWidget::sender()
  QObject * fp_QPrintPreviewWidget_sender_c0 () const {
    return QPrintPreviewWidget::sender();
  }

  //  [expose] void QPrintPreviewWidget::updateMicroFocus()
  void fp_QPrintPreviewWidget_updateMicroFocus_0 () {
    QPrintPreviewWidget::updateMicroFocus();
  }

  //  [adaptor impl] bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPrintPreviewWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPrintPreviewWidget_Adaptor, bool, QObject *, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPrintPreviewWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QPrintPreviewWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QPrintPreviewWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QPrintPreviewWidget_Adaptor, int, int>(&QPrintPreviewWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QPrintPreviewWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QPrintPreviewWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QPrintPreviewWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QPrintPreviewWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QPrintPreviewWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QPrintPreviewWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QPrintPreviewWidget_Adaptor, QSize>(&QPrintPreviewWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QPrintPreviewWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QPrintPreviewWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPrintPreviewWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPrintPreviewWidget_Adaptor, QPaintEngine *>(&QPrintPreviewWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPrintPreviewWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QPrintPreviewWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QPrintPreviewWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QPrintPreviewWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QPrintPreviewWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QPrintPreviewWidget_Adaptor, QSize>(&QPrintPreviewWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QPrintPreviewWidget::sizeHint();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QPrintPreviewWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QPrintPreviewWidget_Adaptor, QActionEvent *>(&QPrintPreviewWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QPrintPreviewWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPrintPreviewWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPrintPreviewWidget_Adaptor, QChildEvent *>(&QPrintPreviewWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPrintPreviewWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QPrintPreviewWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QPrintPreviewWidget_Adaptor, QCloseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QPrintPreviewWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QPrintPreviewWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QPrintPreviewWidget_Adaptor, QContextMenuEvent *>(&QPrintPreviewWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QPrintPreviewWidget::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewWidget::customContextMenuRequested(const QPoint &pos)
  void emitter_QPrintPreviewWidget_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QPrintPreviewWidget::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QPrintPreviewWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::customEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewWidget::destroyed(QObject *)
  void emitter_QPrintPreviewWidget_destroyed_1302(QObject *arg1)
  {
    emit QPrintPreviewWidget::destroyed(arg1);
  }

  //  [adaptor impl] void QPrintPreviewWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPrintPreviewWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPrintPreviewWidget_Adaptor, const char *>(&QPrintPreviewWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPrintPreviewWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QPrintPreviewWidget::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QPrintPreviewWidget_Adaptor, QDragEnterEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QPrintPreviewWidget::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QPrintPreviewWidget::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QPrintPreviewWidget_Adaptor, QDragLeaveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QPrintPreviewWidget::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QPrintPreviewWidget::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QPrintPreviewWidget_Adaptor, QDragMoveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QPrintPreviewWidget::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QPrintPreviewWidget::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QPrintPreviewWidget_Adaptor, QDropEvent *>(&QPrintPreviewWidget_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QPrintPreviewWidget::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QPrintPreviewWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QPrintPreviewWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewWidget::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPrintPreviewWidget::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPrintPreviewWidget_Adaptor, bool, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPrintPreviewWidget::event(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewWidget::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPrintPreviewWidget_Adaptor, QFocusEvent *>(&QPrintPreviewWidget_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QPrintPreviewWidget::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPrintPreviewWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QPrintPreviewWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QPrintPreviewWidget_Adaptor, bool, bool>(&QPrintPreviewWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QPrintPreviewWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QPrintPreviewWidget::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPrintPreviewWidget_Adaptor, QFocusEvent *>(&QPrintPreviewWidget_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QPrintPreviewWidget::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QPrintPreviewWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QPrintPreviewWidget_Adaptor, const QFont &>(&QPrintPreviewWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QPrintPreviewWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPrintPreviewWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPrintPreviewWidget_Adaptor, QHideEvent *>(&QPrintPreviewWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPrintPreviewWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QPrintPreviewWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QPrintPreviewWidget_Adaptor, QInputMethodEvent *>(&QPrintPreviewWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QPrintPreviewWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewWidget::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPrintPreviewWidget_Adaptor, QKeyEvent *>(&QPrintPreviewWidget_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QPrintPreviewWidget::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QPrintPreviewWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPrintPreviewWidget_Adaptor, QKeyEvent *>(&QPrintPreviewWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QPrintPreviewWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QPrintPreviewWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QPrintPreviewWidget_Adaptor>(&QPrintPreviewWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QPrintPreviewWidget::languageChange();
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QPrintPreviewWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QPrintPreviewWidget_Adaptor, QEvent *>(&QPrintPreviewWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QPrintPreviewWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPrintPreviewWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPrintPreviewWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPrintPreviewWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPrintPreviewWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QPrintPreviewWidget::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPrintPreviewWidget_Adaptor, QMouseEvent *>(&QPrintPreviewWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QPrintPreviewWidget::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPrintPreviewWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPrintPreviewWidget_Adaptor, QMoveEvent *>(&QPrintPreviewWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPrintPreviewWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QPrintPreviewWidget::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPrintPreviewWidget_Adaptor, QPaintEvent *>(&QPrintPreviewWidget_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QPrintPreviewWidget::paintEvent(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewWidget::paintRequested(QPrinter *printer)
  void emitter_QPrintPreviewWidget_paintRequested_1443(QPrinter *printer)
  {
    emit QPrintPreviewWidget::paintRequested(printer);
  }

  //  [adaptor impl] void QPrintPreviewWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QPrintPreviewWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QPrintPreviewWidget_Adaptor, const QPalette &>(&QPrintPreviewWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QPrintPreviewWidget::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QPrintPreviewWidget::previewChanged()
  void emitter_QPrintPreviewWidget_previewChanged_0()
  {
    emit QPrintPreviewWidget::previewChanged();
  }

  //  [adaptor impl] void QPrintPreviewWidget::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QPrintPreviewWidget::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPrintPreviewWidget_Adaptor, QResizeEvent *>(&QPrintPreviewWidget_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QPrintPreviewWidget::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPrintPreviewWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPrintPreviewWidget_Adaptor, QShowEvent *>(&QPrintPreviewWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPrintPreviewWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QPrintPreviewWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QPrintPreviewWidget_Adaptor, QStyle &>(&QPrintPreviewWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QPrintPreviewWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPrintPreviewWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPrintPreviewWidget_Adaptor, QTabletEvent *>(&QPrintPreviewWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPrintPreviewWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPrintPreviewWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPrintPreviewWidget_Adaptor, QTimerEvent *>(&QPrintPreviewWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPrintPreviewWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QPrintPreviewWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPrintPreviewWidget_Adaptor, QWheelEvent *>(&QPrintPreviewWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QPrintPreviewWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QPrintPreviewWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QPrintPreviewWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QPrintPreviewWidget_Adaptor, bool>(&QPrintPreviewWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QPrintPreviewWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QPrintPreviewWidget_Adaptor::~QPrintPreviewWidget_Adaptor() { }

//  Constructor QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewWidget_Adaptor_5037 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_2);
  decl->set_return_new<QPrintPreviewWidget_Adaptor> ();
}

static void _call_ctor_QPrintPreviewWidget_Adaptor_5037 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrinter *arg1 = gsi::arg_reader<QPrinter * >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg3 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QPrintPreviewWidget_Adaptor *> (new QPrintPreviewWidget_Adaptor (arg1, arg2, arg3));
}


//  Constructor QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QPrintPreviewWidget_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QPrintPreviewWidget_Adaptor> ();
}

static void _call_ctor_QPrintPreviewWidget_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QPrintPreviewWidget_Adaptor *> (new QPrintPreviewWidget_Adaptor (arg1, arg2));
}


// void QPrintPreviewWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QPrintPreviewWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QPrintPreviewWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPrintPreviewWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_create_2208 (arg1, arg2, arg3);
}


// emitter void QPrintPreviewWidget::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QPrintPreviewWidget_Adaptor *)cls)->emitter_QPrintPreviewWidget_customContextMenuRequested_1916 (arg1);
}


// void QPrintPreviewWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_destroy_1620 (arg1, arg2);
}


// emitter void QPrintPreviewWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QPrintPreviewWidget_Adaptor *)cls)->emitter_QPrintPreviewWidget_destroyed_1302 (arg1);
}


// void QPrintPreviewWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QPrintPreviewWidget::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QPrintPreviewWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QPrintPreviewWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QPrintPreviewWidget::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QPrintPreviewWidget::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QPrintPreviewWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_focusNextChild_0 ());
}


// bool QPrintPreviewWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QPrintPreviewWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_focusPreviousChild_0 ());
}


// void QPrintPreviewWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QPrintPreviewWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QPrintPreviewWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QPrintPreviewWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QPrintPreviewWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QPrintPreviewWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QPrintPreviewWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPrintPreviewWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QPrintPreviewWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QPrintPreviewWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPrintPreviewWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QPrintPreviewWidget::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// emitter void QPrintPreviewWidget::paintRequested(QPrinter *printer)

static void _init_emitter_paintRequested_1443 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_paintRequested_1443 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrinter *arg1 = gsi::arg_reader<QPrinter * >() (args, heap);
  ((QPrintPreviewWidget_Adaptor *)cls)->emitter_QPrintPreviewWidget_paintRequested_1443 (arg1);
}


// void QPrintPreviewWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// emitter void QPrintPreviewWidget::previewChanged()

static void _init_emitter_previewChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_previewChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QPrintPreviewWidget_Adaptor *)cls)->emitter_QPrintPreviewWidget_previewChanged_0 ();
}


// exposed int QPrintPreviewWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_receivers_c1731 (arg1));
}


// exposed void QPrintPreviewWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_resetInputContext_0 ();
}


// void QPrintPreviewWidget::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QPrintPreviewWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_sender_c0 ());
}


// void QPrintPreviewWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QPrintPreviewWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QPrintPreviewWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QPrintPreviewWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QPrintPreviewWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QPrintPreviewWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QPrintPreviewWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QPrintPreviewWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->fp_QPrintPreviewWidget_updateMicroFocus_0 ();
}


// void QPrintPreviewWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QPrintPreviewWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPrintPreviewWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPrintPreviewWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QPrintPreviewWidget> &qtdecl_QPrintPreviewWidget ();

static gsi::Methods methods_QPrintPreviewWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewWidget::QPrintPreviewWidget(QPrinter *printer, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewWidget.", &_init_ctor_QPrintPreviewWidget_Adaptor_5037, &_call_ctor_QPrintPreviewWidget_Adaptor_5037);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPrintPreviewWidget::QPrintPreviewWidget(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QPrintPreviewWidget.", &_init_ctor_QPrintPreviewWidget_Adaptor_3702, &_call_ctor_QPrintPreviewWidget_Adaptor_3702);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QPrintPreviewWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QPrintPreviewWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPrintPreviewWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QPrintPreviewWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QPrintPreviewWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QPrintPreviewWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QPrintPreviewWidget::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPrintPreviewWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QPrintPreviewWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPrintPreviewWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPrintPreviewWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QPrintPreviewWidget::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QPrintPreviewWidget::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QPrintPreviewWidget::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QPrintPreviewWidget::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QPrintPreviewWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QPrintPreviewWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPrintPreviewWidget::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPrintPreviewWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPrintPreviewWidget::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QPrintPreviewWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QPrintPreviewWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPrintPreviewWidget::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QPrintPreviewWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QPrintPreviewWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QPrintPreviewWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPrintPreviewWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QPrintPreviewWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QPrintPreviewWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPrintPreviewWidget::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPrintPreviewWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QPrintPreviewWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QPrintPreviewWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPrintPreviewWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QPrintPreviewWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPrintPreviewWidget::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPrintPreviewWidget::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPrintPreviewWidget::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPrintPreviewWidget::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPrintPreviewWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPrintPreviewWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPrintPreviewWidget::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("emit_paintRequested", "@brief Emitter for signal void QPrintPreviewWidget::paintRequested(QPrinter *printer)\nCall this method to emit this signal.", false, &_init_emitter_paintRequested_1443, &_call_emitter_paintRequested_1443);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QPrintPreviewWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("emit_previewChanged", "@brief Emitter for signal void QPrintPreviewWidget::previewChanged()\nCall this method to emit this signal.", false, &_init_emitter_previewChanged_0, &_call_emitter_previewChanged_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPrintPreviewWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QPrintPreviewWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPrintPreviewWidget::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPrintPreviewWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QPrintPreviewWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPrintPreviewWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QPrintPreviewWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QPrintPreviewWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPrintPreviewWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPrintPreviewWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QPrintPreviewWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPrintPreviewWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QPrintPreviewWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QPrintPreviewWidget_Adaptor> decl_QPrintPreviewWidget_Adaptor (qtdecl_QPrintPreviewWidget (), "QtGui", "QPrintPreviewWidget",
  methods_QPrintPreviewWidget_Adaptor (),
  "@qt\n@brief Binding of QPrintPreviewWidget");

}


//  Implementation of the enum wrapper class for QPrintPreviewWidget::ViewMode
namespace qt_gsi
{

static gsi::Enum<QPrintPreviewWidget::ViewMode> decl_QPrintPreviewWidget_ViewMode_Enum ("QtGui", "QPrintPreviewWidget_ViewMode",
    gsi::enum_const ("SinglePageView", QPrintPreviewWidget::SinglePageView, "@brief Enum constant QPrintPreviewWidget::SinglePageView") +
    gsi::enum_const ("FacingPagesView", QPrintPreviewWidget::FacingPagesView, "@brief Enum constant QPrintPreviewWidget::FacingPagesView") +
    gsi::enum_const ("AllPagesView", QPrintPreviewWidget::AllPagesView, "@brief Enum constant QPrintPreviewWidget::AllPagesView"),
  "@qt\n@brief This class represents the QPrintPreviewWidget::ViewMode enum");

static gsi::QFlagsClass<QPrintPreviewWidget::ViewMode > decl_QPrintPreviewWidget_ViewMode_Enums ("QtGui", "QPrintPreviewWidget_QFlags_ViewMode",
  "@qt\n@brief This class represents the QFlags<QPrintPreviewWidget::ViewMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrintPreviewWidget> inject_QPrintPreviewWidget_ViewMode_Enum_in_parent (decl_QPrintPreviewWidget_ViewMode_Enum.defs ());
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ViewMode_Enum_as_child (decl_QPrintPreviewWidget_ViewMode_Enum, "ViewMode");
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ViewMode_Enums_as_child (decl_QPrintPreviewWidget_ViewMode_Enums, "QFlags_ViewMode");

}


//  Implementation of the enum wrapper class for QPrintPreviewWidget::ZoomMode
namespace qt_gsi
{

static gsi::Enum<QPrintPreviewWidget::ZoomMode> decl_QPrintPreviewWidget_ZoomMode_Enum ("QtGui", "QPrintPreviewWidget_ZoomMode",
    gsi::enum_const ("CustomZoom", QPrintPreviewWidget::CustomZoom, "@brief Enum constant QPrintPreviewWidget::CustomZoom") +
    gsi::enum_const ("FitToWidth", QPrintPreviewWidget::FitToWidth, "@brief Enum constant QPrintPreviewWidget::FitToWidth") +
    gsi::enum_const ("FitInView", QPrintPreviewWidget::FitInView, "@brief Enum constant QPrintPreviewWidget::FitInView"),
  "@qt\n@brief This class represents the QPrintPreviewWidget::ZoomMode enum");

static gsi::QFlagsClass<QPrintPreviewWidget::ZoomMode > decl_QPrintPreviewWidget_ZoomMode_Enums ("QtGui", "QPrintPreviewWidget_QFlags_ZoomMode",
  "@qt\n@brief This class represents the QFlags<QPrintPreviewWidget::ZoomMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPrintPreviewWidget> inject_QPrintPreviewWidget_ZoomMode_Enum_in_parent (decl_QPrintPreviewWidget_ZoomMode_Enum.defs ());
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ZoomMode_Enum_as_child (decl_QPrintPreviewWidget_ZoomMode_Enum, "ZoomMode");
static gsi::ClassExt<QPrintPreviewWidget> decl_QPrintPreviewWidget_ZoomMode_Enums_as_child (decl_QPrintPreviewWidget_ZoomMode_Enums, "QFlags_ZoomMode");

}

