/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialectInsertReplaceMethod;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataBulkLoader;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataManipulatorExt;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.IDataTransferAttributeTransformer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNodePrimary;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="databaseTransferConsumer")
public class DatabaseTransferConsumer
implements IDataTransferConsumer<DatabaseConsumerSettings, IDataTransferProcessor>,
IDataTransferNodePrimary,
DBPReferentialIntegrityController {
    private static final Log log = Log.getLog(DatabaseTransferConsumer.class);
    public static final String NODE_ID = "databaseTransferConsumer";
    private final DBCStatistics statistics = new DBCStatistics();
    private DatabaseConsumerSettings settings;
    private DatabaseMappingContainer containerMapping;
    private ColumnMapping[] columnMappings;
    private DBDAttributeBinding[] sourceBindings;
    private DBCExecutionContext targetContext;
    private DBCSession targetSession;
    private DBSDataManipulator.ExecuteBatch executeBatch;
    private DBSDataBulkLoader.BulkLoadManager bulkLoadManager;
    private long rowsExported = 0L;
    private boolean ignoreErrors = false;
    private List<DBSAttributeBase> targetAttributes;
    private boolean useIsolatedConnection;
    private Boolean oldAutoCommit;
    private DBSObjectContainer targetObjectContainer;
    private DBSDataManipulator localTargetObject;
    private boolean isPreview;
    private List<Object[]> previewRows;
    private DBDAttributeBinding[] rsAttributes;
    private DBSObjectContainer container;

    public void setContainer(DBSObjectContainer container) {
        this.container = container;
    }

    public DatabaseTransferConsumer() {
    }

    public DatabaseTransferConsumer(DBSDataManipulator targetObject) {
        this.localTargetObject = targetObject;
    }

    public DatabaseTransferConsumer(DBSObjectContainer targetObjectContainer) {
        this.targetObjectContainer = targetObjectContainer;
    }

    public DBSObjectContainer getTargetObjectContainer() {
        return this.targetObjectContainer;
    }

    public ColumnMapping[] getColumnMappings() {
        return this.columnMappings;
    }

    @Override
    public DBSObject getDatabaseObject() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer;
        }
        return this.containerMapping == null ? this.localTargetObject : this.containerMapping.getTarget();
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        return this.getDataSourceContainer() == null ? null : this.getDataSourceContainer().getProject();
    }

    protected boolean isPreview() {
        return this.isPreview;
    }

    protected void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    protected List<Object[]> getPreviewRows() {
        return this.previewRows;
    }

    @Nullable
    public List<DBSAttributeBase> getTargetAttributes() {
        return this.targetAttributes;
    }

    /*
     * Unable to fully structure code
     */
    public void fetchStart(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        try {
            this.initExporter(session.getProgressMonitor());
        }
        catch (DBException e) {
            throw new DBCException("Error initializing exporter", (Throwable)e);
        }
        if (this.containerMapping == null) {
            throw new DBCException("Internal error: consumer mappings not set");
        }
        executionSource = new AbstractExecutionSource(this.containerMapping.getSource(), this.targetContext, (Object)this);
        targetObject = this.getTargetObject();
        if (targetObject != null && !this.isPreview && offset <= 0L && this.settings.isTruncateBeforeLoad() && (this.containerMapping == null || this.containerMapping.getMappingType() == DatabaseMappingType.existing)) {
            try {
                targetObject.truncateData(this.targetSession, (DBCExecutionSource)executionSource);
            }
            catch (DBCFeatureNotSupportedException v0) {
                DatabaseTransferConsumer.log.warn((Object)("Table '" + targetObject.getName() + "' doesn't support truncate operation"));
            }
        }
        dynamicTarget = this.targetContext.getDataSource().getInfo().isDynamicMetadata();
        sourceObject = this.getSourceObject();
        this.rsAttributes = dynamicTarget != false ? DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)sourceObject, (DBCResultSetMetaData)resultSet.getMeta()) : DTUtils.makeLeafAttributeBindings(session, sourceObject, resultSet);
        this.columnMappings = new ColumnMapping[this.rsAttributes.length];
        this.sourceBindings = this.rsAttributes;
        this.targetAttributes = new ArrayList<DBSAttributeBase>(this.columnMappings.length);
        i = 0;
        while (i < this.rsAttributes.length) {
            if (!this.isSkipColumn(this.rsAttributes[i])) {
                columnMapping = new ColumnMapping(this.rsAttributes[i]);
                if (this.containerMapping == null) {
                    if (targetObject instanceof DBSEntity) {
                        try {
                            attribute = ((DBSEntity)targetObject).getAttribute(session.getProgressMonitor(), columnMapping.sourceAttr.getName());
                            if (attribute != null) {
                                columnMapping.targetAttr = new DatabaseMappingAttribute(null, (DBSAttributeBase)columnMapping.sourceAttr);
                                columnMapping.targetAttr.setTarget(attribute);
                                columnMapping.targetAttr.setMappingType(DatabaseMappingType.existing);
                            }
                        }
                        catch (DBException v1) {
                            DatabaseTransferConsumer.log.error((Object)"Error getting target attribute");
                        }
                    }
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't resolve target attribute for [" + columnMapping.sourceAttr.getName() + "]");
                    }
                } else if (sourceObject instanceof DBSDocumentContainer && dynamicTarget) {
                    try {
                        docContainer = (DBSDocumentContainer)(targetObject instanceof DBSDocumentContainer != false ? targetObject : sourceObject);
                        docAttribute = docContainer.getDocumentAttribute(session.getProgressMonitor());
                        if (docAttribute == null) ** GOTO lbl55
                        columnMapping.targetAttr = new DatabaseMappingAttribute(this.containerMapping, (DBSAttributeBase)columnMapping.sourceAttr);
                        columnMapping.targetAttr.setTarget(docAttribute);
                        columnMapping.targetAttr.setMappingType(DatabaseMappingType.existing);
                    }
                    catch (DBException e) {
                        throw new DBCException("Error getting document attribute", (Throwable)e);
                    }
                } else {
                    columnMapping.targetAttr = this.containerMapping.getAttributeMapping(columnMapping.sourceAttr);
                    if (columnMapping.targetAttr == null) {
                        throw new DBCException("Can't find target attribute [" + columnMapping.sourceAttr.getName() + "]");
                    }
                }
lbl55:
                // 5 sources

                if (columnMapping.targetAttr.getMappingType() != DatabaseMappingType.skip) {
                    if (columnMapping.targetAttr.getTransformer() != null) {
                        try {
                            columnMapping.valueTransformer = columnMapping.targetAttr.getTransformer().createTransformer();
                            columnMapping.valueTransformerProperties = columnMapping.targetAttr.getTransformerProperties();
                        }
                        catch (DBException e) {
                            throw new DBCException("Can't create attribute transformer", (Throwable)e);
                        }
                    }
                    if ((targetAttr = columnMapping.targetAttr.getTarget()) == null) {
                        if (this.isPreview) {
                            targetAttr = new PreviewColumnInfo(null, columnMapping.sourceAttr, columnMapping.targetIndex);
                        } else if (columnMapping.targetAttr.getSource() instanceof DBSEntityAttribute || targetObject instanceof DBSDocumentContainer) {
                            targetAttr = columnMapping.targetAttr.getSource();
                        } else {
                            throw new DBCException("Target attribute for [" + columnMapping.sourceAttr.getName() + "] wasn't resolved");
                        }
                    }
                    columnMapping.sourceValueHandler = columnMapping.sourceAttr.getValueHandler();
                    columnMapping.targetValueHandler = DBUtils.findValueHandler((DBPDataSource)this.targetContext.getDataSource(), (DBSTypedObject)targetAttr);
                    columnMapping.targetIndex = this.targetAttributes.size();
                    this.columnMappings[i] = columnMapping;
                    this.targetAttributes.add((DBSAttributeBase)targetAttr);
                }
            }
            ++i;
        }
        attributes = this.targetAttributes.toArray(new DBSAttributeBase[0]);
        options = new HashMap<String, Boolean>();
        options.put("data.manipulate.useMultiInsert", this.settings.isUseMultiRowInsert());
        options.put("data.manipulate.skipBindValues", this.settings.isSkipBindValues());
        if (!this.isPreview && targetObject != null) {
            if (this.settings.isUseBulkLoad() && (bulkLoader = (DBSDataBulkLoader)DBUtils.getAdapter(DBSDataBulkLoader.class, (Object)this.targetContext.getDataSource())) != null) {
                try {
                    this.bulkLoadManager = bulkLoader.createBulkLoad(this.targetSession, (DBSDataContainer)targetObject, attributes, (DBCExecutionSource)executionSource, this.settings.getCommitAfterRows(), options);
                }
                catch (Exception e) {
                    throw new DBCException("Error creating bulk loader", (Throwable)e);
                }
            }
            if (this.bulkLoadManager == null) {
                if (targetObject instanceof DBSDataManipulatorExt) {
                    ((DBSDataManipulatorExt)targetObject).beforeDataChange(this.targetSession, DBSManipulationType.INSERT, attributes, (DBCExecutionSource)executionSource);
                }
                this.executeBatch = targetObject.insertData(this.targetSession, attributes, null, (DBCExecutionSource)executionSource, options);
            }
        } else {
            this.previewRows = new ArrayList<Object[]>();
            this.executeBatch = new PreviewBatch();
        }
    }

    private boolean isSkipColumn(DBDAttributeBinding attr) {
        return attr.isPseudoAttribute() || !this.settings.isTransferAutoGeneratedColumns() && attr.isAutoGenerated() || attr instanceof DBDAttributeBindingCustom;
    }

    public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        Object document;
        if (session.getDataSource().getInfo().isDynamicMetadata()) {
            DBDAttributeBinding attr = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.getSourceObject(), (DBCResultSetMetaData)resultSet.getMeta())[0];
            document = attr.getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)attr, attr.getOrdinalPosition());
        } else {
            document = null;
        }
        Object[] rowValues = new Object[this.targetAttributes.size()];
        int i = 0;
        while (i < this.columnMappings.length) {
            ColumnMapping column = this.columnMappings[i];
            if (column != null && column.targetIndex >= 0) {
                Object attrValue = column.sourceValueHandler != null ? (column.sourceAttr instanceof DBDAttributeBindingCustom ? DBUtils.getAttributeValue((DBDAttributeBinding)column.sourceAttr, (DBDAttributeBinding[])this.sourceBindings, (Object[])rowValues) : column.sourceValueHandler.fetchValueObject(session, resultSet, (DBSTypedObject)column.sourceAttr, column.sourceAttr.getOrdinalPosition())) : resultSet.getAttributeValue(i);
                if (this.containerMapping != null && this.containerMapping.getTarget() instanceof DBSDocumentContainer) {
                    rowValues[column.targetIndex] = attrValue;
                } else {
                    DatabaseMappingAttribute targetAttr = column.targetAttr;
                    rowValues[column.targetIndex] = column.targetValueHandler.getValueFromObject(this.targetSession, (DBSTypedObject)(targetAttr.getTarget() == null ? targetAttr.getSource() : targetAttr.getTarget()), attrValue, false, false);
                }
            }
            ++i;
        }
        ColumnMapping[] columnMappingArray = this.columnMappings;
        int n = this.columnMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnMapping column = columnMappingArray[n2];
            if (column != null && column.targetIndex >= 0 && column.valueTransformer != null) {
                Object attrValue = rowValues[column.targetIndex];
                try {
                    Object[] objectArray;
                    int n3 = column.targetIndex;
                    IDataTransferAttributeTransformer iDataTransferAttributeTransformer = column.valueTransformer;
                    if (document != null) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = document;
                    } else {
                        objectArray = rowValues;
                    }
                    rowValues[n3] = iDataTransferAttributeTransformer.transformAttribute(session, this.rsAttributes, objectArray, column.sourceAttr, document != null ? document : attrValue, column.valueTransformerProperties);
                }
                catch (DBException e) {
                    throw new DBCException("Error transforming attribute '" + column.sourceAttr.getName() + "' value with transformer '" + column.targetAttr.getTransformer().getName() + "'", (Throwable)e);
                }
            }
            ++n2;
        }
        if (this.bulkLoadManager != null) {
            this.bulkLoadManager.addRow(this.targetSession, rowValues);
        } else {
            this.executeBatch.add(rowValues);
        }
        ++this.rowsExported;
        this.insertBatch(false);
    }

    private void insertBatch(boolean force) throws DBCException {
        DBCTransactionManager txnManager;
        boolean needCommit;
        if (this.isPreview) {
            return;
        }
        boolean ignoreDuplicateRowsErrors = this.settings.isIgnoreDuplicateRows();
        boolean bl = needCommit = force || ignoreDuplicateRowsErrors || this.rowsExported % (long)this.settings.getCommitAfterRows() == 0L;
        if (this.bulkLoadManager != null) {
            if (needCommit) {
                this.bulkLoadManager.flushRows(this.targetSession);
            }
            return;
        }
        boolean disableUsingBatches = this.settings.isDisableUsingBatches();
        if ((needCommit || disableUsingBatches) && this.executeBatch != null) {
            boolean retryInsert;
            SQLDialectInsertReplaceMethod insertReplaceMethod;
            String insertMethodId;
            boolean onDuplicateKeyCaseOn;
            if (DBFetchProgress.monitorFetchProgress((long)this.rowsExported)) {
                this.targetSession.getProgressMonitor().subTask("Insert rows (" + this.rowsExported + ")");
            }
            HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
            options.put("data.manipulate.disableBatches", Boolean.valueOf(disableUsingBatches));
            options.put("data.manipulate.multiInsertBatchSize", Integer.valueOf(this.settings.getMultiRowInsertBatch()));
            options.put("data.manipulate.skipBindValues", Boolean.valueOf(this.settings.isSkipBindValues()));
            boolean bl2 = onDuplicateKeyCaseOn = this.settings.getOnDuplicateKeyInsertMethodId() != null && !this.settings.getOnDuplicateKeyInsertMethodId().equals("<None>");
            if (onDuplicateKeyCaseOn && !CommonUtils.isEmpty((String)(insertMethodId = this.settings.getOnDuplicateKeyInsertMethodId())) && (insertReplaceMethod = DBWorkbench.getPlatform().getSQLDialectRegistry().getInsertReplaceMethod(insertMethodId)) != null) {
                try {
                    DBDInsertReplaceMethod insertMethod = insertReplaceMethod.createInsertMethod();
                    options.put("data.manipulate.insertReplaceMethod", (Comparable<Boolean>)insertMethod);
                }
                catch (DBException e) {
                    log.debug((Object)"Can't get insert replace method", (Throwable)e);
                }
            }
            do {
                retryInsert = false;
                try {
                    DBExecUtils.tryExecuteRecover((Object)this.targetSession, (DBPDataSource)this.targetSession.getDataSource(), param -> {
                        try {
                            this.statistics.accumulate(this.executeBatch.execute(this.targetSession, options));
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (Throwable e) {
                    DBPErrorAssistant.ErrorType errorType;
                    if (ignoreDuplicateRowsErrors && e.getCause() instanceof SQLException && (errorType = DBExecUtils.discoverErrorType((DBPDataSource)this.targetSession.getDataSource(), (Throwable)e.getCause())) == DBPErrorAssistant.ErrorType.UNIQUE_KEY_VIOLATION) break;
                    log.error((Object)"Error inserting row", e);
                    if (this.ignoreErrors) break;
                    if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                        if (e instanceof DBCException) {
                            DBCException dbe = (DBCException)e;
                            throw dbe;
                        }
                        throw new DBCException(e.getMessage(), e);
                    }
                    String message = disableUsingBatches ? DTMessages.database_transfer_consumer_task_error_occurred_during_data_load : DTMessages.database_transfer_consumer_task_error_occurred_during_batch_insert;
                    DBPPlatformUI.UserResponse response = DBWorkbench.getPlatformUI().showErrorStopRetryIgnore(message, e, true);
                    switch (response) {
                        case STOP: {
                            throw new DBCException("Can't insert row", e);
                        }
                        case RETRY: {
                            boolean bl3 = true;
                            break;
                        }
                        case IGNORE: {
                            boolean bl3 = false;
                            break;
                        }
                        case IGNORE_ALL: {
                            this.ignoreErrors = true;
                            boolean bl3 = false;
                            break;
                        }
                        default: {
                            boolean bl3 = retryInsert = retryInsert;
                        }
                    }
                }
            } while (retryInsert);
        }
        if (this.settings.isUseTransactions() && needCommit && !this.targetSession.getProgressMonitor().isCanceled() && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            this.targetSession.getProgressMonitor().subTask("Commit changes");
            txnManager.commit(this.targetSession);
        }
    }

    public void fetchEnd(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        try {
            if (this.rowsExported > 0L) {
                this.insertBatch(true);
            }
            if (this.bulkLoadManager != null) {
                this.bulkLoadManager.finishBulkLoad(this.targetSession);
            } else if (this.executeBatch != null) {
                this.executeBatch.close();
                this.executeBatch = null;
            }
        }
        finally {
            DBSDataManipulator targetObject = this.getTargetObject();
            if (!this.isPreview && targetObject instanceof DBSDataManipulatorExt) {
                ((DBSDataManipulatorExt)targetObject).afterDataChange(this.targetSession, DBSManipulationType.INSERT, this.targetAttributes.toArray(new DBSAttributeBase[0]), (DBCExecutionSource)new AbstractExecutionSource(this.getSourceObject(), this.targetContext, (Object)this));
            }
        }
    }

    public void close() {
        this.closeExporter();
    }

    private void initExporter(DBRProgressMonitor monitor) throws DBException {
        DBCTransactionManager txnManager;
        DBSObject targetDB = this.checkTargetContainer(monitor);
        DBPDataSourceContainer dataSourceContainer = targetDB.getDataSource().getContainer();
        if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_IMPORT_DATA)) {
            throw new DBCException("Data transfer to database [" + dataSourceContainer.getName() + "] restricted by connection configuration");
        }
        try {
            this.useIsolatedConnection = !this.isPreview && this.settings.isOpenNewConnections() && !dataSourceContainer.getDriver().isEmbedded();
            this.targetContext = this.useIsolatedConnection ? DBUtils.getObjectOwnerInstance((DBSObject)targetDB).openIsolatedContext(monitor, "Data transfer consumer", null) : DBUtils.getDefaultContext((DBSObject)targetDB, (boolean)false);
        }
        catch (DBException e) {
            throw new DBCException("Error opening new connection", (Throwable)e);
        }
        this.targetSession = this.targetContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data load");
        this.targetSession.enableLogging(this.settings.isEnableQmLogging());
        if (!this.isPreview && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && txnManager.isSupportsTransactions()) {
            this.oldAutoCommit = txnManager.isAutoCommit();
            if (this.settings.isUseTransactions()) {
                if (this.oldAutoCommit.booleanValue()) {
                    txnManager.setAutoCommit(monitor, false);
                }
            } else if (!this.oldAutoCommit.booleanValue()) {
                txnManager.setAutoCommit(monitor, true);
            }
        }
    }

    private DBSObject checkTargetContainer(DBRProgressMonitor monitor) throws DBException {
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject == null) {
            DBSObjectContainer container = this.settings.getContainer();
            if (container instanceof DBPDataSourceContainer && container.getDataSource() == null) {
                DBUtils.initDataSource((DBRProgressMonitor)monitor, (DBPDataSourceContainer)((DBPDataSourceContainer)this.settings.getContainer()), null);
            }
            if (this.settings.getContainer() == null) {
                throw new DBCException("Can't initialize database consumer. No target object and no target container");
            }
        }
        return targetObject == null ? this.settings.getContainer() : targetObject;
    }

    private void closeExporter() {
        if (!this.isPreview && this.targetSession != null && this.oldAutoCommit != null) {
            try {
                DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext());
                if (txnManager != null && txnManager.isSupportsTransactions()) {
                    if (!txnManager.isAutoCommit()) {
                        txnManager.rollback(this.targetSession, null);
                    }
                    txnManager.setAutoCommit(this.targetSession.getProgressMonitor(), this.oldAutoCommit.booleanValue());
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error reverting auto-commit mode", (Throwable)e);
            }
        }
        try {
            if (this.targetSession != null) {
                this.targetSession.close();
                this.targetSession = null;
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
        if (this.targetContext != null && this.useIsolatedConnection) {
            this.targetContext.close();
            this.targetContext = null;
        }
        if (this.bulkLoadManager != null) {
            this.bulkLoadManager.close();
            this.bulkLoadManager = null;
        }
    }

    @Override
    public void initTransfer(@NotNull DBSObject sourceObject, @Nullable DatabaseConsumerSettings settings, @NotNull IDataTransferConsumer.TransferParameters parameters, @Nullable IDataTransferProcessor processor, @Nullable Map<String, Object> processorProperties, @Nullable DBPProject project) {
        this.settings = settings;
        this.containerMapping = settings.getDataMapping((DBSDataContainer)sourceObject);
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Create necessary database objects", 1);
        try {
            DBSObject dbObject = this.checkTargetContainer(monitor);
            if (!this.isPreview && this.containerMapping != null) {
                DBSObjectContainer container = this.settings.getContainer();
                if (container == null) {
                    throw new DBException("No target datasource - can't create target objects");
                }
                boolean hasNewObjects = this.createTargetDatabaseObjects(monitor, dbObject);
                if (hasNewObjects) {
                    DatabaseTransferUtils.refreshDatabaseModel(monitor, this.settings, this.containerMapping);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean createTargetDatabaseObjects(DBRProgressMonitor monitor, DBSObject dbObject) throws DBException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)dbObject, (String)"Create target metadata");){
            boolean bl;
            block23: {
                DBCExecutionContextDefaults contextDefaults;
                DBSCatalog catalog;
                DBSCatalog oldCatalog = null;
                DBSSchema oldSchema = null;
                DBSCatalog dBSCatalog = catalog = dbObject instanceof DBSSchema ? (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)dbObject) : null;
                if (catalog != null && (contextDefaults = session.getExecutionContext().getContextDefaults()) != null && contextDefaults.supportsCatalogChange() && contextDefaults.getDefaultCatalog() != catalog) {
                    oldCatalog = contextDefaults.getDefaultCatalog();
                    try {
                        contextDefaults.setDefaultCatalog(monitor, catalog, (DBSSchema)dbObject);
                    }
                    catch (DBCException e) {
                        log.debug((Object)e);
                    }
                }
                try {
                    switch (this.containerMapping.getMappingType()) {
                        case existing: 
                        case create: 
                        case recreate: {
                            boolean bl2 = this.createTargetTable(session, this.containerMapping);
                            break;
                        }
                        default: {
                            boolean bl2 = bl = false;
                        }
                    }
                    if (oldCatalog == null) break block23;
                }
                catch (Throwable throwable2) {
                    if (oldCatalog != null) {
                        try {
                            session.getExecutionContext().getContextDefaults().setDefaultCatalog(monitor, oldCatalog, oldSchema);
                        }
                        catch (DBCException e) {
                            log.debug((Object)e);
                        }
                    }
                    throw throwable2;
                }
                try {
                    session.getExecutionContext().getContextDefaults().setDefaultCatalog(monitor, oldCatalog, oldSchema);
                }
                catch (DBCException e) {
                    log.debug((Object)e);
                }
            }
            return bl;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private boolean createTargetTable(DBCSession session, DatabaseMappingContainer containerMapping) throws DBException {
        DBSObjectContainer schema = this.settings.getContainer();
        if (schema == null) {
            throw new DBException("No target container selected");
        }
        if (session.getDataSource().getInfo().isDynamicMetadata()) {
            if (containerMapping.hasNewTargetObject()) {
                DatabaseTransferUtils.createTargetDynamicTable(session.getProgressMonitor(), session.getExecutionContext(), schema, containerMapping, containerMapping.getTarget() != null);
            }
            return true;
        }
        DBEPersistAction[] actions = DatabaseTransferUtils.generateTargetTableDDL(session.getProgressMonitor(), session.getExecutionContext(), schema, containerMapping, containerMapping.getChangedPropertiesMap());
        try {
            DatabaseTransferUtils.executeDDL(session, actions);
        }
        catch (DBCException e) {
            throw new DBCException("Can't create or update target table:\n" + SQLUtils.generateScript((DBPDataSource)session.getDataSource(), (DBEPersistAction[])actions, (boolean)false), (Throwable)e);
        }
        return actions.length > 0;
    }

    @Override
    public void finishTransfer(@NotNull DBRProgressMonitor monitor, boolean last) {
        this.finishTransfer(monitor, null, last);
    }

    @Override
    public void finishTransfer(@NotNull DBRProgressMonitor monitor, @Nullable Throwable error, @Nullable DBTTask task, boolean last) {
        DBNModel navigatorModel;
        boolean headlessMode = DBWorkbench.getPlatform().getApplication().isHeadlessMode();
        if (last && error == null) {
            monitor.subTask("Refresh final database model");
            try {
                DBSObjectContainer container = this.settings.getContainer();
                navigatorModel = DBNUtils.getNavigatorModel((DBSObject)container);
                if (navigatorModel != null) {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBSObject)this.containerMapping.getTarget());
                    if (node == null) {
                        node = DBNUtils.getNodeByObject((DBSObject)container);
                    }
                    if (node != null) {
                        node.refreshNode(monitor, (Object)this);
                    }
                } else if (container instanceof DBPRefreshableObject) {
                    DBPRefreshableObject refreshableObject = (DBPRefreshableObject)container;
                    refreshableObject.refreshObject(monitor);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Error refreshing database model after data consumer", (Throwable)e);
            }
        }
        if (!headlessMode && !last && this.settings.isOpenTableOnFinish() && error == null) {
            try {
                DatabaseTransferUtils.refreshDatabaseMappings(monitor, this.settings, this.containerMapping, true);
            }
            catch (Exception e) {
                log.error((Object)"Error refreshing database model", (Throwable)e);
            }
            DBSDataManipulator targetObject = this.getTargetObject();
            if (targetObject != null) {
                try {
                    navigatorModel = DBNUtils.getNavigatorModel((DBSObject)targetObject);
                    if (navigatorModel != null) {
                        DBNDatabaseNode objectNode = DBNUtils.getNodeByObject((DBSObject)targetObject);
                        if (objectNode != null) {
                            objectNode.refreshNode(monitor, DBNEvent.FORCE_REFRESH);
                        }
                    } else if (targetObject instanceof DBPRefreshableObject) {
                        DBPRefreshableObject ro = (DBPRefreshableObject)targetObject;
                        ro.refreshObject(monitor);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error refreshing object '" + targetObject.getName() + "'"), (Throwable)e);
                }
                try {
                    DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)targetObject);
                }
                catch (Exception e) {
                    log.error((Object)("Error opening entity editor for '" + targetObject.getName() + "'"), (Throwable)e);
                }
            }
        }
        if (last) {
            DataTransferRegistry registry = DataTransferRegistry.getInstance();
            for (Map.Entry<String, Map<String, Object>> entry : this.settings.getEventProcessors().entrySet()) {
                DataTransferEventProcessorDescriptor descriptor = registry.getEventProcessorById(entry.getKey());
                if (descriptor == null) {
                    log.debug((Object)("Can't find event processor '" + entry.getKey() + "'"));
                    continue;
                }
                try {
                    IDataTransferEventProcessor<DatabaseTransferConsumer> processor = descriptor.create();
                    if (error == null) {
                        processor.processEvent(monitor, IDataTransferEventProcessor.Event.FINISH, this, task, entry.getValue());
                        continue;
                    }
                    processor.processError(monitor, error, this, task, entry.getValue());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Transfer event processor", "Error executing data transfer event processor '" + entry.getKey() + "'", (Throwable)e);
                }
            }
        }
    }

    public DBSDataContainer getSourceObject() {
        return this.containerMapping == null ? null : this.containerMapping.getSource();
    }

    public DBSDataManipulator getTargetObject() {
        return this.containerMapping == null ? this.localTargetObject : this.containerMapping.getTarget();
    }

    public void setTargetObject(DBSDataManipulator targetObject) {
        this.localTargetObject = targetObject;
    }

    public DBSObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public String getObjectName() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer.getName();
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        String targetName = null;
        if (targetObject != null) {
            targetName = DBUtils.getObjectFullName((DBPNamedObject)targetObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (targetName != null) {
            return targetName + " [Existing]";
        }
        if (this.containerMapping == null) {
            return "?";
        }
        targetName = this.containerMapping.getTargetFullName();
        return switch (this.containerMapping.getMappingType()) {
            case DatabaseMappingType.create -> targetName + " [Create]";
            case DatabaseMappingType.recreate -> targetName + " [Recreate]";
            case DatabaseMappingType.existing -> {
                for (DatabaseMappingAttribute attr : this.containerMapping.getAttributeMappings((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                    yield targetName + " [Alter]";
                }
                yield targetName;
            }
            case DatabaseMappingType.skip -> "[Skip]";
            default -> targetName + " [Existing]";
        };
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.targetObjectContainer != null) {
            return DBIcon.TREE_FOLDER_TABLE;
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject instanceof DBPImageProvider) {
            return DBValueFormatting.getObjectImage((DBPObject)targetObject);
        }
        return DBIcon.TREE_TABLE;
    }

    @Override
    public String getObjectContainerName() {
        if (this.targetObjectContainer != null) {
            return DBUtils.getObjectFullName((DBPNamedObject)this.targetObjectContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getName() : "?";
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        if (this.targetObjectContainer != null) {
            return DBIcon.TREE_FOLDER_TABLE;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container != null ? container.getDriver().getIcon() : null;
    }

    @Override
    public boolean isConfigurationComplete() {
        if (this.localTargetObject != null) {
            return true;
        }
        return this.containerMapping != null && (this.containerMapping.getTarget() != null || !CommonUtils.isEmpty((String)this.containerMapping.getTargetName()));
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.targetObjectContainer != null) {
            return this.targetObjectContainer.getDataSource().getContainer();
        }
        DBSDataManipulator targetObject = this.getTargetObject();
        if (targetObject != null) {
            return targetObject.getDataSource().getContainer();
        }
        DBSObjectContainer container = this.settings.getContainer();
        if (container != null) {
            return container.getDataSource().getContainer();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseTransferConsumer && CommonUtils.equalObjects((Object)this.getTargetObject(), (Object)((DatabaseTransferConsumer)obj).getTargetObject());
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.checkTargetContainer(monitor) instanceof DBPReferentialIntegrityController;
    }

    /*
     * WARNING - void declaration
     */
    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        void controller;
        DBSObject dbsObject = this.checkTargetContainer(monitor);
        if (!(dbsObject instanceof DBPReferentialIntegrityController)) {
            throw new DBException("Changing referential integrity is unsupported!");
        }
        DBPReferentialIntegrityController dBPReferentialIntegrityController = (DBPReferentialIntegrityController)dbsObject;
        controller.enableReferentialIntegrity(monitor, enable);
    }

    @Nullable
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        DBSObject dbsObject = this.checkTargetContainer(monitor);
        if (dbsObject instanceof DBPReferentialIntegrityController) {
            return ((DBPReferentialIntegrityController)dbsObject).getChangeReferentialIntegrityStatement(monitor, enable);
        }
        return null;
    }

    public DatabaseConsumerSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setSettings(@Nullable DatabaseConsumerSettings settings) {
        this.settings = settings;
    }

    public void setContainerMapping(@Nullable DatabaseMappingContainer containerMapping) {
        this.containerMapping = containerMapping;
    }

    public static class ColumnMapping {
        public DBDAttributeBinding sourceAttr;
        public DatabaseMappingAttribute targetAttr;
        public DBDValueHandler sourceValueHandler;
        public DBDValueHandler targetValueHandler;
        public int targetIndex = -1;
        public IDataTransferAttributeTransformer valueTransformer;
        public Map<String, Object> valueTransformerProperties;

        private ColumnMapping(DBDAttributeBinding sourceAttr) {
            this.sourceAttr = sourceAttr;
        }

        public String toString() {
            return String.valueOf(this.sourceAttr) + "->" + String.valueOf(this.targetAttr);
        }
    }

    private class PreviewBatch
    implements DBSDataManipulator.ExecuteBatch {
        private PreviewBatch() {
        }

        public void add(@NotNull Object[] attributeValues) throws DBCException {
            DatabaseTransferConsumer.this.previewRows.add(attributeValues);
        }

        @NotNull
        public DBCStatistics execute(@NotNull DBCSession session, @NotNull Map<String, Object> options) throws DBCException {
            return new DBCStatistics();
        }

        public void generatePersistActions(@NotNull DBCSession session, @NotNull List<DBEPersistAction> actions, @NotNull Map<String, Object> options) throws DBCException {
        }

        public void close() {
        }
    }

    private static class PreviewColumnInfo
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private final DBSEntity entity;
        private final DBDAttributeBinding binding;

        public PreviewColumnInfo(DBSEntity entity, DBDAttributeBinding binding, int index) {
            super(binding.getName(), binding.getTypeName(), -1, index, binding.getMaxLength(), null, null, false, false);
            this.entity = entity;
            this.binding = binding;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return this.entity;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return this.binding.getDataSource();
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return this.binding.getDataKind();
        }
    }
}

