/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.operations.execution.CachingDisabledReasonCategory;
import org.jspecify.annotations.Nullable;

public class ExecuteTaskBuildOperationResult
implements ExecuteTaskBuildOperationType.Result {
    private final TaskStateInternal taskState;
    private final CachingState cachingState;
    private final OriginMetadata originMetadata;
    private final boolean incremental;
    private final List<String> executionReasons;

    public ExecuteTaskBuildOperationResult(TaskStateInternal taskState, CachingState cachingState, @Nullable OriginMetadata originMetadata, boolean incremental, List<String> executionReasons) {
        this.taskState = taskState;
        this.cachingState = cachingState;
        this.originMetadata = originMetadata;
        this.incremental = incremental;
        this.executionReasons = executionReasons;
    }

    public @Nullable String getSkipMessage() {
        return this.taskState.getSkipMessage();
    }

    public @Nullable String getSkipReasonMessage() {
        return this.taskState.getSkipReasonMessage();
    }

    public boolean isActionable() {
        return this.taskState.isActionable();
    }

    public @Nullable String getOriginBuildInvocationId() {
        return this.originMetadata == null ? null : this.originMetadata.getBuildInvocationId();
    }

    public byte @Nullable [] getOriginBuildCacheKeyBytes() {
        return this.originMetadata == null ? null : this.originMetadata.getBuildCacheKey().toByteArray();
    }

    public @Nullable Long getOriginExecutionTime() {
        return this.originMetadata == null ? null : Long.valueOf(this.originMetadata.getExecutionTime().toMillis());
    }

    public @Nullable String getCachingDisabledReasonMessage() {
        return this.getCachingDisabledReason().map(CachingDisabledReason::getMessage).orElse(null);
    }

    public @Nullable String getCachingDisabledReasonCategory() {
        return this.getCachingDisabledReason().map(CachingDisabledReason::getCategory).map(ExecuteTaskBuildOperationResult::convertNoCacheReasonCategory).map(Enum::name).orElse(null);
    }

    private Optional<CachingDisabledReason> getCachingDisabledReason() {
        return this.cachingState.whenDisabled().map(CachingState.Disabled::getDisabledReasons).map(reasons -> (CachingDisabledReason)reasons.get(0));
    }

    private static CachingDisabledReasonCategory convertNoCacheReasonCategory(org.gradle.internal.execution.caching.CachingDisabledReasonCategory category) {
        switch (category) {
            case UNKNOWN: {
                return CachingDisabledReasonCategory.UNKNOWN;
            }
            case BUILD_CACHE_DISABLED: {
                return CachingDisabledReasonCategory.BUILD_CACHE_DISABLED;
            }
            case NOT_CACHEABLE: {
                return CachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK;
            }
            case ENABLE_CONDITION_NOT_SATISFIED: {
                return CachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED;
            }
            case DISABLE_CONDITION_SATISFIED: {
                return CachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED;
            }
            case NO_OUTPUTS_DECLARED: {
                return CachingDisabledReasonCategory.NO_OUTPUTS_DECLARED;
            }
            case NON_CACHEABLE_OUTPUT: {
                return CachingDisabledReasonCategory.NON_CACHEABLE_TREE_OUTPUT;
            }
            case OVERLAPPING_OUTPUTS: {
                return CachingDisabledReasonCategory.OVERLAPPING_OUTPUTS;
            }
            case VALIDATION_FAILURE: {
                return CachingDisabledReasonCategory.VALIDATION_FAILURE;
            }
        }
        throw new AssertionError();
    }

    public List<String> getUpToDateMessages() {
        return this.executionReasons;
    }

    public boolean isIncremental() {
        return this.incremental;
    }
}

