/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.authentication.Authentication;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceFactory;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.Build.class})
public class SecureFileDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureFileDownloader.class);
    private final ExternalResourceFactory externalResourceFactory;

    public SecureFileDownloader(ExternalResourceFactory externalResourceFactory) {
        this.externalResourceFactory = externalResourceFactory;
    }

    public ExternalResource getResourceFor(URI source, Collection<Authentication> authentications) {
        return this.createExternalResource(source, authentications);
    }

    public ExternalResource getResourceFor(URI source) {
        return this.createExternalResource(source, Collections.emptyList());
    }

    public void download(URI source, File destination, ExternalResource resource) {
        try {
            this.downloadResource(source, destination, resource);
        }
        catch (MissingResourceException e) {
            throw new MissingResourceException(source, String.format("Unable to download '%s' into file '%s'", source, destination), (Throwable)e);
        }
    }

    private ExternalResource createExternalResource(final URI source, Collection<Authentication> authentications) {
        ExternalResourceName resourceName = new ExternalResourceName(source){

            public String getShortDisplayName() {
                return source.toString();
            }
        };
        return this.externalResourceFactory.createExternalResource(source, authentications).withProgressLogging().resource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource(URI source, File targetFile, ExternalResource resource) {
        File downloadFile = new File(targetFile.getAbsoluteFile() + ".part");
        try {
            resource.withContent(inputStream -> {
                LOGGER.info("Downloading {} to {}", (Object)resource.getDisplayName(), (Object)targetFile);
                this.copyIntoFile(source, (InputStream)inputStream, downloadFile);
            });
            try {
                this.moveFile(targetFile, downloadFile);
            }
            catch (IOException e) {
                throw new GradleException("Unable to move downloaded file to target destination", (Throwable)e);
            }
        }
        finally {
            downloadFile.delete();
        }
    }

    private void moveFile(File targetFile, File downloadFile) throws IOException {
        try {
            Files.move(downloadFile.toPath(), targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(downloadFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void copyIntoFile(URI source, InputStream inputStream, File destination) {
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw ResourceExceptions.getFailed((URI)source, (Throwable)e);
        }
    }
}

