/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirUnusedCheckerBase;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirUnusedReturnValueCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J2\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001c\u0010\u0010\u001a\u00060\u0011R\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase;", "<init>", "()V", "isEnabled", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportUnusedExpressionIfNeeded", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "hasSideEffects", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "createVisitor", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageVisitorBase;", "UsageVisitor", "checkers"})
public final class FirUnusedReturnValueChecker
extends FirUnusedCheckerBase {
    @NotNull
    public static final FirUnusedReturnValueChecker INSTANCE = new FirUnusedReturnValueChecker();

    private FirUnusedReturnValueChecker() {
    }

    @Override
    public boolean isEnabled(@NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getReturnValueCheckerMode()) != ReturnValueCheckerMode.DISABLED;
    }

    @Override
    public boolean reportUnusedExpressionIfNeeded(@NotNull FirExpression expression2, boolean hasSideEffects, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source) {
        FirCallableSymbol resolvedSymbol;
        FirResolvedNamedReference resolvedReference;
        FirReference calleeReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!hasSideEffects) {
            return false;
        }
        if (FirUnusedReturnValueCheckerKt.access$isIgnorable(FirTypeUtilsKt.getResolvedType(expression2))) {
            return false;
        }
        FirReference firReference = calleeReference = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        FirResolvedNamedReference firResolvedNamedReference = resolvedReference = firReference != null ? FirReferenceUtilsKt.getResolved(firReference) : null;
        FirCallableSymbol firCallableSymbol = resolvedSymbol = firResolvedNamedReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firResolvedNamedReference, false, 1, null) : null;
        if (resolvedSymbol != null && !FirUnusedReturnValueCheckerKt.access$isSubjectToCheck(resolvedSymbol, context2.getSession())) {
            return false;
        }
        FirCallableSymbol firCallableSymbol2 = resolvedSymbol;
        boolean bl = firCallableSymbol2 != null ? FirUnusedReturnValueCheckerKt.access$isExcluded(firCallableSymbol2, context2.getSession()) : false;
        if (bl) {
            return false;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getRETURN_VALUE_NOT_USED(), (DiagnosticContext)context2, null, 8, null);
        return true;
    }

    @Override
    @NotNull
    protected FirUnusedCheckerBase.UsageVisitorBase createVisitor(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        return new UsageVisitor(context2, reporter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueChecker$UsageVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageVisitorBase;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitElvisExpression", "", "elvisExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedCheckerBase$UsageState;", "visitSafeCallExpression", "safeCallExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "visitCheckNotNullCall", "checkNotNullCall", "Lorg/jetbrains/kotlin/fir/expressions/FirCheckNotNullCall;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueChecker$UsageVisitor\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n48#2:184\n46#2:185\n1869#3,2:186\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnusedReturnValueChecker$UsageVisitor\n*L\n105#1:184\n109#1:185\n109#1:186,2\n*E\n"})
    private static final class UsageVisitor
    extends FirUnusedCheckerBase.UsageVisitorBase {
        public UsageVisitor(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            super(context2, reporter);
        }

        @Override
        public void visitElvisExpression(@NotNull FirElvisExpression elvisExpression, @NotNull FirUnusedCheckerBase.UsageState data) {
            Intrinsics.checkNotNullParameter((Object)elvisExpression, (String)"elvisExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            elvisExpression.getLhs().accept(this, data);
            elvisExpression.getRhs().accept(this, data);
        }

        @Override
        public void visitSafeCallExpression(@NotNull FirSafeCallExpression safeCallExpression, @NotNull FirUnusedCheckerBase.UsageState data) {
            Intrinsics.checkNotNullParameter((Object)safeCallExpression, (String)"safeCallExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            safeCallExpression.getSelector().accept(this, data);
        }

        @Override
        public void visitCheckNotNullCall(@NotNull FirCheckNotNullCall checkNotNullCall, @NotNull FirUnusedCheckerBase.UsageState data) {
            Intrinsics.checkNotNullParameter((Object)checkNotNullCall, (String)"checkNotNullCall");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            FirCall $this$argument$iv = checkNotNullCall;
            boolean $i$f$getArgument = false;
            ((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())).accept(this, data);
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull FirUnusedCheckerBase.UsageState data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            FirCall $this$arguments$iv = typeOperatorCall;
            boolean $i$f$getArguments = false;
            Iterable $this$forEach$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                it.accept(this, data);
            }
        }
    }
}

