/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeSelectionSchema;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.gradle.internal.component.model.DefaultMultipleCandidateResult;
import org.jspecify.annotations.Nullable;

public class DefaultAttributeSelectionSchema
implements AttributeSelectionSchema {
    private final ImmutableAttributesSchema schema;

    public DefaultAttributeSelectionSchema(ImmutableAttributesSchema schema) {
        this.schema = schema;
    }

    @Override
    public boolean hasAttribute(Attribute<?> attribute) {
        return this.schema.getAttributes().contains(attribute);
    }

    @Override
    public <T> Set<T> disambiguate(Attribute<T> attribute, @Nullable T requested, Set<T> candidates) {
        DisambiguationRule<T> rules = this.schema.disambiguationRules(attribute);
        if (rules.doesSomething()) {
            DefaultMultipleCandidateResult<T> result = new DefaultMultipleCandidateResult<T>(requested, candidates);
            rules.execute(result);
            if (result.hasResult()) {
                return result.getMatches();
            }
        }
        if (requested != null && candidates.contains(requested)) {
            return Collections.singleton(requested);
        }
        return null;
    }

    @Override
    public <T> boolean matchValue(Attribute<T> attribute, T requested, T candidate) {
        if (requested.equals(candidate)) {
            return true;
        }
        CompatibilityRule<T> rules = this.schema.compatibilityRules(attribute);
        if (rules.doesSomething()) {
            DefaultCompatibilityCheckResult<T> result = new DefaultCompatibilityCheckResult<T>(requested, candidate);
            rules.execute(result);
            if (result.hasResult()) {
                return result.isCompatible();
            }
        }
        return false;
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        return this.schema.getAttributeByName(name);
    }

    @Override
    public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] candidateAttributeSets, ImmutableAttributes requested) {
        LinkedHashSet extraAttributes = new LinkedHashSet();
        for (ImmutableAttributes attributes : candidateAttributeSets) {
            extraAttributes.addAll((Collection<Attribute<?>>)attributes.keySet());
        }
        DefaultAttributeSelectionSchema.removeSameAttributes(requested, extraAttributes);
        Attribute[] extraAttributesArray = extraAttributes.toArray(new Attribute[0]);
        for (int i = 0; i < extraAttributesArray.length; ++i) {
            extraAttributesArray[i] = this.tryRehydrate(extraAttributesArray[i]);
        }
        return extraAttributesArray;
    }

    private static void removeSameAttributes(ImmutableAttributes requested, Set<Attribute<?>> extraAttributes) {
        block0: for (Attribute attribute : requested.keySet()) {
            Iterator<Attribute<?>> it = extraAttributes.iterator();
            while (it.hasNext()) {
                Attribute<?> next = it.next();
                if (!next.getName().equals(attribute.getName())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    public AttributeSelectionSchema.PrecedenceResult orderByPrecedence(Collection<Attribute<?>> requested) {
        if (this.schema.getAttributeDisambiguationPrecedence().isEmpty()) {
            return new AttributeSelectionSchema.PrecedenceResult(IntStream.range(0, requested.size()).boxed().collect(Collectors.toList()));
        }
        LinkedHashMap<String, Integer> remaining = new LinkedHashMap<String, Integer>();
        int position = 0;
        for (Attribute<?> requestedAttribute : requested) {
            remaining.put(requestedAttribute.getName(), position++);
        }
        ArrayList<Integer> sorted = new ArrayList<Integer>(remaining.size());
        for (Attribute preferredAttribute : this.schema.getAttributeDisambiguationPrecedence()) {
            if (!requested.contains(preferredAttribute)) continue;
            sorted.add((Integer)remaining.remove(preferredAttribute.getName()));
        }
        if (sorted.isEmpty()) {
            return new AttributeSelectionSchema.PrecedenceResult(remaining.values());
        }
        return new AttributeSelectionSchema.PrecedenceResult(sorted, remaining.values());
    }
}

