/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.resources.TextResource;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class FileNotationConverter
implements NotationConverter<Object, File> {
    public static NotationParser<Object, File> parser() {
        return NotationParserBuilder.toType(File.class).typeDisplayName("a File").noImplicitConverters().converter((NotationConverter)new FileNotationConverter()).toComposite();
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("A String or CharSequence path").example("'src/main/java' or '/usr/include'");
        visitor.candidate("A String or CharSequence URI").example("'file:/usr/include'");
        visitor.candidate("A File instance.");
        visitor.candidate("A Path instance.");
        visitor.candidate("A Directory instance.");
        visitor.candidate("A RegularFile instance.");
        visitor.candidate("A URI or URL instance of file.");
        visitor.candidate("A TextResource instance.");
    }

    public void convert(Object notation, NotationConvertResult<? super File> result) throws TypeConversionException {
        if (notation instanceof File) {
            result.converted((Object)((File)notation));
            return;
        }
        if (notation instanceof Path) {
            result.converted((Object)((Path)notation).toFile());
            return;
        }
        if (notation instanceof FileSystemLocation) {
            result.converted((Object)((FileSystemLocation)notation).getAsFile());
            return;
        }
        if (notation instanceof URL) {
            try {
                notation = ((URL)notation).toURI();
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        if (notation instanceof URI) {
            URI uri = (URI)notation;
            if ("file".equals(uri.getScheme())) {
                try {
                    result.converted((Object)new File(uri));
                    return;
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidUserDataException(String.format("Cannot convert URI '%s' to a file.", uri), (Throwable)ex);
                }
            }
            return;
        }
        if (notation instanceof CharSequence) {
            String notationString = notation.toString();
            try {
                if (notationString.startsWith("file:")) {
                    result.converted((Object)new File(new URI(notationString)));
                } else {
                    result.converted((Object)new File(notationString));
                }
            }
            catch (Exception ex) {
                throw new InvalidUserDataException(String.format("Cannot convert URI '%s' to a file.", notationString), (Throwable)ex);
            }
            return;
        }
        if (notation instanceof TextResource) {
            result.converted((Object)((TextResource)notation).asFile());
        }
    }
}

