/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import java.io.File;
import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.nativeplatform.tasks.UnexportMainSymbol;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPlatformPathLocator;
import org.gradle.platform.base.Platform;
import org.gradle.util.internal.GUtil;

public abstract class XCTestConventionPlugin
implements Plugin<Project> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;
    private final ObjectFactory objectFactory;
    private final AttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory, ObjectFactory objectFactory, AttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        ProviderFactory providers = project.getProviders();
        DefaultSwiftXCTestSuite testSuite = (DefaultSwiftXCTestSuite)this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", (Object)testSuite);
        project.getComponents().add((Object)testSuite);
        testSuite.getModule().set((Object)GUtil.toCamelCase((CharSequence)(project.getName() + "Test")));
        DefaultSwiftXCTestSuite testComponent = testSuite;
        testComponent.getTargetMachines().convention((Iterable)Dimensions.useHostAsDefaultTargetMachine((TargetMachineFactory)this.targetMachineFactory));
        testComponent.getSourceCompatibility().convention(testComponent.getTestedComponent().flatMap(it -> it.getSourceCompatibility()));
        String mainComponentName = "main";
        project.getComponents().withType(ProductionSwiftComponent.class, component -> {
            if ("main".equals(component.getName())) {
                testComponent.getTargetMachines().convention((Provider)component.getTargetMachines());
                testComponent.getTestedComponent().convention(component);
            }
        });
        testComponent.getTestBinary().convention(project.provider(() -> testComponent.getBinaries().get().stream().filter(SwiftXCTestBinary.class::isInstance).map(SwiftXCTestBinary.class::cast).findFirst().orElse(null)));
        testComponent.getBinaries().whenElementKnown(DefaultSwiftXCTestBinary.class, binary -> {
            TaskProvider testingTask = project.getTasks().register("xcTest", XCTest.class, task -> {
                task.setGroup("verification");
                task.setDescription("Executes XCTest suites");
                task.getTestInstallDirectory().set((Provider)binary.getInstallDirectory());
                task.getRunScriptFile().set((Provider)binary.getRunScriptFile());
                task.getWorkingDirectory().set((Provider)binary.getInstallDirectory());
            });
            binary.getRunTask().set((Provider)testingTask);
            this.configureTestSuiteBuildingTasks(project, (DefaultSwiftXCTestBinary)binary);
            this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, (DefaultSwiftXCTestBinary)binary);
        });
        project.afterEvaluate(p -> {
            SwiftComponent mainComponent = (SwiftComponent)testComponent.getTestedComponent().getOrNull();
            SetProperty mainTargetMachines = mainComponent != null ? mainComponent.getTargetMachines() : null;
            Dimensions.unitTestVariants((Provider)testComponent.getModule(), (SetProperty)testComponent.getTargetMachines(), (SetProperty)mainTargetMachines, (ObjectFactory)this.objectFactory, (AttributesFactory)this.attributesFactory, (Provider)providers.provider(() -> project.getGroup().toString()), (Provider)providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost((NativeVariantIdentity)variantIdentity)) {
                    testComponent.getSourceCompatibility().finalizeValue();
                    ToolChainSelector.Result result = this.toolChainSelector.select(SwiftPlatform.class, (Object)new DefaultSwiftPlatform(variantIdentity.getTargetMachine(), (SwiftVersion)testComponent.getSourceCompatibility().getOrNull()));
                    if (((SwiftPlatform)result.getTargetPlatform()).getTargetMachine().getOperatingSystemFamily().isMacOs()) {
                        testComponent.addBundle((NativeVariantIdentity)variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    } else {
                        testComponent.addExecutable((NativeVariantIdentity)variantIdentity, (SwiftPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    }
                }
            });
            testComponent.getBinaries().realizeNow();
        });
    }

    private void configureTestSuiteBuildingTasks(Project project, DefaultSwiftXCTestBinary binary) {
        SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
        compile.getSource().setFrom((Iterable)binary.getSwiftSource().getAsFileTree().matching(patterns -> patterns.include(new String[]{"**/*"}).exclude(new String[]{"**/LinuxMain.swift"})));
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainer tasks = project.getTasks();
            Names names = binary.getNames();
            DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            NativeToolChainRegistryInternal toolChainRegistry = (NativeToolChainRegistryInternal)Cast.uncheckedCast((Object)project.getExtensions().getByType(NativeToolChainRegistry.class));
            NativeToolChain toolChain = (NativeToolChain)toolChainRegistry.getForPlatform((Platform)currentPlatform);
            compile.getCompilerArgs().addAll(project.provider(() -> {
                File platformSdkPath = this.sdkPlatformPathLocator.find();
                File frameworkDir = new File(platformSdkPath, "Developer/Library/Frameworks");
                File extraInclude = new File(platformSdkPath, "Developer/usr/lib");
                return Arrays.asList("-parse-as-library", "-F" + frameworkDir.getAbsolutePath(), "-I", extraInclude.getAbsolutePath(), "-v");
            }));
            TaskProvider link = tasks.register(names.getTaskName("link"), LinkMachOBundle.class, task -> {
                task.getLinkerArgs().set(project.provider(() -> {
                    File platformSdkPath = this.sdkPlatformPathLocator.find();
                    File frameworkDir = new File(platformSdkPath, "Developer/Library/Frameworks");
                    File extraInclude = new File(platformSdkPath, "Developer/usr/lib");
                    return Arrays.asList("-F" + frameworkDir.getAbsolutePath(), "-L", extraInclude.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks");
                }));
                task.source((Object)binary.getObjects());
                task.lib((Object)binary.getLinkLibraries());
                PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                Provider exeLocation = project.getLayout().getBuildDirectory().file(binary.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + baseName)));
                task.getLinkedFile().set(exeLocation);
                task.getTargetPlatform().set((Object)currentPlatform);
                task.getToolChain().set((Object)toolChain);
                task.getDebuggable().set((Object)binary.isDebuggable());
            });
            TaskProvider install = tasks.register(names.getTaskName("install"), InstallXCTestBundle.class, task -> {
                task.getBundleBinaryFile().set((Provider)((LinkMachOBundle)link.get()).getLinkedFile());
                task.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            });
            binary.getInstallDirectory().set(install.flatMap(task -> task.getInstallDirectory()));
            binary.getExecutableFile().set(link.flatMap(task -> task.getLinkedFile()));
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set((Provider)link);
            bundle.getRunScriptFile().set(install.flatMap(task -> task.getRunScriptFile()));
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(executable.getInstallTask().flatMap(task -> task.getRunScriptFile()));
            if (binary.getTargetMachine().getOperatingSystemFamily().isLinux()) {
                TaskProvider renameLinuxMainTask = project.getTasks().register("renameLinuxMain", Sync.class, task -> {
                    task.from(new Object[]{binary.getSwiftSource()});
                    task.into((Object)project.getLayout().getBuildDirectory().dir("linuxMain"));
                    task.include(new String[]{"LinuxMain.swift"});
                    task.rename(".*", "main.swift");
                });
                compile.getSource().from(new Object[]{project.files(new Object[]{renameLinuxMainTask.map(Sync::getDestinationDir)}).getAsFileTree().matching(patterns -> patterns.include(new String[]{"**/*.swift"}))});
            }
        }
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, DefaultSwiftXCTestSuite testSuite, DefaultSwiftXCTestBinary testExecutable) {
        SwiftComponent target = (SwiftComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionSwiftComponent)) {
            return;
        }
        ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)target;
        TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized(testedBinary -> {
            if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                return;
            }
            testExecutable.getImplementationDependencies().extendsFrom(new Configuration[]{((DefaultSwiftBinary)testedBinary).getImplementationDependencies()});
            Dependency compileDependency = project.getDependencies().create((Object)project.files(new Object[]{testedBinary.getModuleFile()}));
            testExecutable.getImportPathConfiguration().getDependencies().add((Object)compileDependency);
            ConfigurableFileCollection testableObjects = project.files(new Object[0]);
            if (testedComponent instanceof SwiftApplication) {
                TaskProvider unexportMainSymbol = tasks.register("relocateMainForTest", UnexportMainSymbol.class, task -> {
                    String dirName = ((DefaultSwiftBinary)testedBinary).getNames().getDirName();
                    task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/for-test/" + dirName));
                    task.getObjects().from(new Object[]{testedBinary.getObjects()});
                });
                testableObjects.from(new Object[]{unexportMainSymbol.map(task -> task.getRelocatedObjects())});
            } else {
                testableObjects.from(new Object[]{testedBinary.getObjects()});
            }
            Dependency linkDependency = project.getDependencies().create((Object)testableObjects);
            testExecutable.getLinkConfiguration().getDependencies().add((Object)linkDependency);
        });
    }
}

