/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.evaluation.OperationGenerationId;
import org.gradle.declarative.dsl.schema.AnalysisSchema;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.DataTypeRef;
import org.gradle.declarative.dsl.schema.FqName;
import org.gradle.internal.declarativedsl.analysis.AnalysisContextView;
import org.gradle.internal.declarativedsl.analysis.AnalysisScope;
import org.gradle.internal.declarativedsl.analysis.AssignmentMethod;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.DataAdditionRecord;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.NestedObjectAccessRecord;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.OperationId;
import org.gradle.internal.declarativedsl.analysis.PropertyReferenceResolution;
import org.gradle.internal.declarativedsl.analysis.SchemaTypeRefContext;
import org.gradle.internal.declarativedsl.analysis.TypedOrigin;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0016J&\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u001e\u0010<\u001a\u00020\u00182\u0006\u00104\u001a\u0002052\u0006\u0010=\u001a\u00020>2\u0006\u0010:\u001a\u00020;J\u0016\u0010?\u001a\u0002012\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ\u0016\u0010C\u001a\u0002012\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020DJ\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0 8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0 8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContextView;", "schema", "Lorg/gradle/declarative/dsl/schema/AnalysisSchema;", "imports", "", "", "Lorg/gradle/declarative/dsl/schema/FqName;", "errorCollector", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "generationId", "Lorg/gradle/declarative/dsl/evaluation/OperationGenerationId;", "<init>", "(Lorg/gradle/declarative/dsl/schema/AnalysisSchema;Ljava/util/Map;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;Lorg/gradle/declarative/dsl/evaluation/OperationGenerationId;)V", "getSchema", "()Lorg/gradle/declarative/dsl/schema/AnalysisSchema;", "getImports", "()Ljava/util/Map;", "getErrorCollector", "()Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "mutableScopes", "", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisScope;", "mutableAssignments", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "nextInstant", "Ljava/util/concurrent/atomic/AtomicLong;", "mutableAdditions", "Lorg/gradle/internal/declarativedsl/analysis/DataAdditionRecord;", "mutableNestedObjectAccess", "Lorg/gradle/internal/declarativedsl/analysis/NestedObjectAccessRecord;", "currentScopes", "", "getCurrentScopes", "()Ljava/util/List;", "assignments", "getAssignments", "additions", "getAdditions", "nestedObjectAccess", "getNestedObjectAccess", "typeRefContext", "Lorg/gradle/internal/declarativedsl/analysis/SchemaTypeRefContext;", "resolveRef", "Lorg/gradle/declarative/dsl/schema/DataType;", "dataTypeRef", "Lorg/gradle/declarative/dsl/schema/DataTypeRef;", "maybeResolveRef", "enterScope", "", "newScope", "recordAssignment", "resolvedTarget", "Lorg/gradle/internal/declarativedsl/analysis/PropertyReferenceResolution;", "resolvedRhs", "Lorg/gradle/internal/declarativedsl/analysis/TypedOrigin;", "assignmentMethod", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentMethod;", "originElement", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "recordAugmentingAssignment", "resolvedResult", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$AugmentationOrigin;", "recordAddition", "container", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "dataObject", "recordNestedObjectAccess", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$AccessAndConfigureReceiver;", "nextCallId", "Lorg/gradle/internal/declarativedsl/analysis/OperationId;", "leaveScope", "scope", "declarative-dsl-core"})
public final class AnalysisContext
implements AnalysisContextView {
    @NotNull
    private final AnalysisSchema schema;
    @NotNull
    private final Map<String, FqName> imports;
    @NotNull
    private final ErrorCollector errorCollector;
    @NotNull
    private final OperationGenerationId generationId;
    @NotNull
    private final List<AnalysisScope> mutableScopes;
    @NotNull
    private final List<AssignmentRecord> mutableAssignments;
    @NotNull
    private final AtomicLong nextInstant;
    @NotNull
    private final List<DataAdditionRecord> mutableAdditions;
    @NotNull
    private final List<NestedObjectAccessRecord> mutableNestedObjectAccess;
    @NotNull
    private final SchemaTypeRefContext typeRefContext;

    public AnalysisContext(@NotNull AnalysisSchema schema, @NotNull Map<String, ? extends FqName> imports, @NotNull ErrorCollector errorCollector, @NotNull OperationGenerationId generationId) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(imports, (String)"imports");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        Intrinsics.checkNotNullParameter((Object)generationId, (String)"generationId");
        this.schema = schema;
        this.imports = imports;
        this.errorCollector = errorCollector;
        this.generationId = generationId;
        this.mutableScopes = new ArrayList();
        this.mutableAssignments = new ArrayList();
        this.nextInstant = new AtomicLong(1L);
        this.mutableAdditions = new ArrayList();
        this.mutableNestedObjectAccess = new ArrayList();
        this.typeRefContext = new SchemaTypeRefContext(this.getSchema());
    }

    @Override
    @NotNull
    public AnalysisSchema getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public Map<String, FqName> getImports() {
        return this.imports;
    }

    @NotNull
    public final ErrorCollector getErrorCollector() {
        return this.errorCollector;
    }

    @NotNull
    public List<AnalysisScope> getCurrentScopes() {
        return this.mutableScopes;
    }

    @Override
    @NotNull
    public List<AssignmentRecord> getAssignments() {
        return this.mutableAssignments;
    }

    @NotNull
    public final List<DataAdditionRecord> getAdditions() {
        return this.mutableAdditions;
    }

    @NotNull
    public final List<NestedObjectAccessRecord> getNestedObjectAccess() {
        return this.mutableNestedObjectAccess;
    }

    @Override
    @NotNull
    public DataType resolveRef(@NotNull DataTypeRef dataTypeRef) {
        Intrinsics.checkNotNullParameter((Object)dataTypeRef, (String)"dataTypeRef");
        return this.typeRefContext.resolveRef(dataTypeRef);
    }

    @Override
    @Nullable
    public DataType maybeResolveRef(@NotNull DataTypeRef dataTypeRef) {
        Intrinsics.checkNotNullParameter((Object)dataTypeRef, (String)"dataTypeRef");
        return this.typeRefContext.maybeResolveRef(dataTypeRef);
    }

    public final void enterScope(@NotNull AnalysisScope newScope) {
        Intrinsics.checkNotNullParameter((Object)newScope, (String)"newScope");
        this.mutableScopes.add(newScope);
    }

    @NotNull
    public final AssignmentRecord recordAssignment(@NotNull PropertyReferenceResolution resolvedTarget, @NotNull TypedOrigin resolvedRhs, @NotNull AssignmentMethod assignmentMethod, @NotNull LanguageTreeElement originElement) {
        Intrinsics.checkNotNullParameter((Object)resolvedTarget, (String)"resolvedTarget");
        Intrinsics.checkNotNullParameter((Object)resolvedRhs, (String)"resolvedRhs");
        Intrinsics.checkNotNullParameter((Object)assignmentMethod, (String)"assignmentMethod");
        Intrinsics.checkNotNullParameter((Object)originElement, (String)"originElement");
        AssignmentRecord result = new AssignmentRecord(resolvedTarget, resolvedRhs.getObjectOrigin(), this.nextCallId(), assignmentMethod, originElement);
        this.mutableAssignments.add(result);
        return result;
    }

    @NotNull
    public final AssignmentRecord recordAugmentingAssignment(@NotNull PropertyReferenceResolution resolvedTarget, @NotNull ObjectOrigin.AugmentationOrigin resolvedResult, @NotNull LanguageTreeElement originElement) {
        Intrinsics.checkNotNullParameter((Object)resolvedTarget, (String)"resolvedTarget");
        Intrinsics.checkNotNullParameter((Object)resolvedResult, (String)"resolvedResult");
        Intrinsics.checkNotNullParameter((Object)originElement, (String)"originElement");
        AssignmentRecord result = new AssignmentRecord(resolvedTarget, resolvedResult, this.nextCallId(), AssignmentMethod.Augmentation.INSTANCE, originElement);
        this.mutableAssignments.add(result);
        return result;
    }

    public final void recordAddition(@NotNull ObjectOrigin container, @NotNull ObjectOrigin dataObject) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        ((Collection)this.mutableAdditions).add(new DataAdditionRecord(container, dataObject, this.nextCallId()));
    }

    public final void recordNestedObjectAccess(@NotNull ObjectOrigin container, @NotNull ObjectOrigin.AccessAndConfigureReceiver dataObject) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)dataObject, (String)"dataObject");
        ((Collection)this.mutableNestedObjectAccess).add(new NestedObjectAccessRecord(container, dataObject, this.nextCallId()));
    }

    @NotNull
    public final OperationId nextCallId() {
        return new OperationId(this.nextInstant.incrementAndGet(), this.generationId);
    }

    public final void leaveScope(@NotNull AnalysisScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (!(CollectionsKt.last(this.mutableScopes) == scope)) {
            throw new IllegalStateException("Check failed.");
        }
        CollectionsKt.removeLast(this.mutableScopes);
    }
}

