/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class DefaultOutputSnapshotter
implements OutputSnapshotter {
    private final FileCollectionSnapshotter fileCollectionSnapshotter;

    public DefaultOutputSnapshotter(FileCollectionSnapshotter fileCollectionSnapshotter) {
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
    }

    @Override
    public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputs(UnitOfWork work, File workspace) {
        final ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        work.visitOutputs(workspace, new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, UnitOfWork.OutputFileValueSupplier value) {
                FileSystemSnapshot snapshot;
                try {
                    snapshot = DefaultOutputSnapshotter.this.fileCollectionSnapshotter.snapshot(value.getFiles());
                }
                catch (Exception ex) {
                    throw new OutputSnapshotter.OutputFileSnapshottingException(propertyName, ex);
                }
                builder.put((Object)propertyName, (Object)snapshot);
            }
        });
        return builder.build();
    }
}

