/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List<String> ivyPatterns = new ArrayList<String>();
    private List<String> artifactPatterns = new ArrayList<String>();
    private boolean m2compatible = false;

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        if (this.isM2compatible()) {
            mrid = this.convertM2ResourceSearchIdToNormal(mrid);
        }
        return super.findResource(rress, rmdparser, mrid, date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List<String> patternList, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        HashSet<String> foundRevisions = new HashSet<String>();
        boolean dynamic = this.getSettings().getVersionMatcher().isDynamic(moduleRevision);
        for (String pattern : patternList) {
            ResolvedResource rres = this.findResourceUsingPattern(moduleRevision, pattern, artifact, rmdparser, date);
            if (rres == null || foundRevisions.contains(rres.getRevision())) continue;
            foundRevisions.add(rres.getRevision());
            resolvedResources.add(rres);
            if (dynamic) continue;
            break;
        }
        if (resolvedResources.size() > 1) {
            ResolvedResource[] rress = resolvedResources.toArray(new ResolvedResource[resolvedResources.size()]);
            return this.findResource(rress, rmdparser, moduleRevision, date);
        }
        if (resolvedResources.size() == 1) {
            return (ResolvedResource)resolvedResources.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    @Override
    protected Collection<String> findNames(Map<String, String> tokenValues, String token) {
        HashSet<String> names = new HashSet<String>(this.findIvyNames(tokenValues, token));
        if (this.isAllownomd()) {
            names.addAll(this.findArtifactNames(tokenValues, token));
        }
        return names;
    }

    protected Collection<String> findIvyNames(Map<String, String> tokenValues, String token) {
        HashSet<String> names = new HashSet<String>();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    protected Collection<String> findArtifactNames(Map<String, String> tokenValues, String token) {
        HashSet<String> names = new HashSet<String>();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.filterNames(names);
        return names;
    }

    @Override
    public Map<String, String>[] listTokenValues(String[] tokens, Map<String, Object> criteria) {
        LinkedHashSet<Map<String, String>> result = new LinkedHashSet<Map<String, String>>();
        HashMap<String, Object> subcriteria = new HashMap<String, Object>(criteria);
        subcriteria.put("type", "ivy");
        subcriteria.put("ext", this.getModuleDescriptorExtension());
        if (this.isM2compatible()) {
            this.convertM2CriteriaForResourceSearch(subcriteria);
        }
        for (String ivyPattern : this.getIvyPatterns()) {
            result.addAll(this.resolveTokenValues(tokens, ivyPattern, subcriteria, false));
        }
        if (this.isAllownomd()) {
            subcriteria = new HashMap<String, Object>(criteria);
            subcriteria.put("type", "jar");
            subcriteria.put("ext", "jar");
            if (this.isM2compatible()) {
                this.convertM2CriteriaForResourceSearch(subcriteria);
            }
            for (String artifactPattern : this.getArtifactPatterns()) {
                result.addAll(this.resolveTokenValues(tokens, artifactPattern, subcriteria, true));
            }
        }
        return result.toArray(new Map[result.size()]);
    }

    protected String getModuleDescriptorExtension() {
        return "xml";
    }

    private Set<Map<String, String>> resolveTokenValues(String[] tokens, String pattern, Map<String, Object> criteria, boolean noMd) {
        String[] values;
        LinkedHashSet<Map<String, String>> result = new LinkedHashSet<Map<String, String>>();
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens));
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : criteria.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            tokenValues.put(entry.getKey(), (String)value);
        }
        if (tokenSet.isEmpty()) {
            result.add(tokenValues);
            return result;
        }
        String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern, tokenValues);
        String token = IvyPatternHelper.getFirstToken(partiallyResolvedPattern);
        if (token == null && this.exist(partiallyResolvedPattern)) {
            result.add(tokenValues);
            return result;
        }
        tokenSet.remove(token);
        Matcher matcher = null;
        Object criteriaForToken = criteria.get(token);
        if (criteriaForToken instanceof Matcher) {
            matcher = (Matcher)criteriaForToken;
        }
        if ((values = this.listTokenValues(partiallyResolvedPattern, token)) == null) {
            return result;
        }
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(values));
        this.filterNames(valueList);
        for (String value : valueList) {
            if (matcher != null && !matcher.matches(value)) continue;
            tokenValues.put(token, value);
            String moreResolvedPattern = IvyPatternHelper.substituteTokens(partiallyResolvedPattern, tokenValues);
            HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
            newCriteria.put(token, value);
            if (noMd && "artifact".equals(token)) {
                newCriteria.put("module", value);
            } else if (noMd && "module".equals(token)) {
                newCriteria.put("artifact", value);
            }
            result.addAll(this.resolveTokenValues(tokenSet.toArray(new String[tokenSet.size()]), moreResolvedPattern, newCriteria, noMd));
        }
        return result;
    }

    protected abstract String[] listTokenValues(String var1, String var2);

    protected abstract boolean exist(String var1);

    protected void findTokenValues(Collection<String> names, List<String> patterns, Map<String, String> tokenValues, String token) {
    }

    public void addIvyPattern(String pattern) {
        this.ivyPatterns.add(pattern);
    }

    public void addArtifactPattern(String pattern) {
        this.artifactPatterns.add(pattern);
    }

    public List<String> getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List<String> getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List<String> patterns) {
        this.ivyPatterns = patterns;
    }

    protected void setArtifactPatterns(List<String> patterns) {
        this.artifactPatterns = patterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this.ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this.artifactPatterns.add(p.getPattern());
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        for (String p : this.getIvyPatterns()) {
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        for (String p : this.getArtifactPatterns()) {
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean compatible) {
        this.m2compatible = compatible;
    }

    protected ModuleRevisionId convertM2ResourceSearchIdToNormal(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(47) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('/', '.'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected String convertM2OrganizationForResourceSearch(String org) {
        return org.replace('.', '/');
    }

    protected void convertM2TokenValuesForResourceSearch(Map<String, String> tokenValues) {
        tokenValues.put("organisation", this.convertM2OrganizationForResourceSearch(tokenValues.get("organisation")));
    }

    protected void convertM2CriteriaForResourceSearch(Map<String, Object> criteria) {
        Object org = criteria.get("organisation");
        if (org instanceof String) {
            criteria.put("organisation", this.convertM2OrganizationForResourceSearch((String)org));
        }
    }
}

