/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.util.Path;

public class TestTreeModel {
    private final Path path;
    private final Map<Integer, PerRootInfo> perRootInfo;
    private final Map<String, TestTreeModel> children;

    public static TestTreeModel loadModelFromStores(List<SerializableTestResultStore> stores) throws IOException {
        HashMap<Path, TestTreeModel> modelsByPath = new HashMap<Path, TestTreeModel>();
        for (int i = 0; i < stores.size(); ++i) {
            SerializableTestResultStore store = stores.get(i);
            store.forEachResult(new StoreLoader(i, modelsByPath));
        }
        TestTreeModel rootModel = (TestTreeModel)modelsByPath.get(Path.ROOT);
        if (rootModel == null) {
            throw new IllegalStateException("All provided stores were empty");
        }
        return rootModel;
    }

    public TestTreeModel(Path path, Map<Integer, PerRootInfo> perRootInfo, Map<String, TestTreeModel> children) {
        this.path = path;
        this.perRootInfo = perRootInfo;
        this.children = children;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<Integer, PerRootInfo> getPerRootInfo() {
        return Collections.unmodifiableMap(this.perRootInfo);
    }

    public Map<String, TestTreeModel> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public Iterable<TestTreeModel> getChildrenOf(int rootIndex) {
        return Iterables.transform(this.perRootInfo.get(rootIndex).getChildren(), this.children::get);
    }

    private static final class StoreLoader
    implements Consumer<SerializableTestResultStore.OutputTrackedResult> {
        private final int rootIndex;
        private final Map<Path, TestTreeModel> modelsByPath;
        private final ListMultimap<Long, Child> childrenByParentId;

        public StoreLoader(int rootIndex, Map<Path, TestTreeModel> modelsByPath) {
            this.rootIndex = rootIndex;
            this.modelsByPath = modelsByPath;
            this.childrenByParentId = ArrayListMultimap.create();
        }

        @Override
        public void accept(SerializableTestResultStore.OutputTrackedResult result) {
            List children = this.childrenByParentId.get((Object)result.getOutputId());
            int totalLeafCount = 0;
            int failedLeafCount = 0;
            int skippedLeafCount = 0;
            for (Child child2 : children) {
                totalLeafCount += child2.info.totalLeafCount;
                failedLeafCount += child2.info.failedLeafCount;
                skippedLeafCount += child2.info.skippedLeafCount;
            }
            if (children.isEmpty()) {
                totalLeafCount = 1;
                if (result.getInnerResult().getResultType() == TestResult.ResultType.FAILURE) {
                    failedLeafCount = 1;
                } else if (result.getInnerResult().getResultType() == TestResult.ResultType.SKIPPED) {
                    skippedLeafCount = 1;
                }
            }
            List<String> childNames = children.stream().map(child -> ((Child)child).info.getResult().getName()).collect(Collectors.toList());
            PerRootInfo thisInfo = new PerRootInfo(result, childNames, totalLeafCount, failedLeafCount, skippedLeafCount);
            OptionalLong parentOutputId = result.getParentOutputId();
            if (!parentOutputId.isPresent()) {
                this.finalizePath(Path.ROOT, result.getOutputId(), thisInfo);
            } else {
                this.childrenByParentId.put((Object)parentOutputId.getAsLong(), (Object)new Child(result.getOutputId(), thisInfo));
            }
        }

        private void finalizePath(Path path, long id, PerRootInfo rootInfo) {
            TestTreeModel model = this.modelsByPath.computeIfAbsent(path, p -> new TestTreeModel((Path)p, (Map<Integer, PerRootInfo>)new LinkedHashMap<Integer, PerRootInfo>(), (Map<String, TestTreeModel>)new HashMap<String, TestTreeModel>()));
            model.perRootInfo.put(this.rootIndex, rootInfo);
            for (Child child : this.childrenByParentId.get((Object)id)) {
                Path childPath = path.child(child.info.outputTrackedResult.getInnerResult().getName());
                this.finalizePath(childPath, child.id, child.info);
                model.children.computeIfAbsent(child.info.outputTrackedResult.getInnerResult().getName(), n -> this.modelsByPath.get(childPath));
            }
        }

        private static final class Child {
            private final long id;
            private final PerRootInfo info;

            private Child(long id, PerRootInfo info) {
                this.id = id;
                this.info = info;
            }
        }
    }

    public static final class PerRootInfo {
        private final SerializableTestResultStore.OutputTrackedResult outputTrackedResult;
        private final List<String> children;
        private final int totalLeafCount;
        private final int failedLeafCount;
        private final int skippedLeafCount;

        public PerRootInfo(SerializableTestResultStore.OutputTrackedResult outputTrackedResult, List<String> children, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            this.outputTrackedResult = outputTrackedResult;
            this.children = children;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        public SerializableTestResult getResult() {
            return this.outputTrackedResult.getInnerResult();
        }

        public long getOutputId() {
            return this.outputTrackedResult.getOutputId();
        }

        public List<String> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        public List<SerializedMetadata> getMetadatas() {
            return this.outputTrackedResult.getInnerResult().getMetadatas();
        }
    }
}

