/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FormFocusTraversalPolicy
extends FocusTraversalPolicy {
    private ArrayList m_focus_list = new ArrayList();
    private HashMap m_comp_map = new HashMap();

    public FormFocusTraversalPolicy(Collection collection) {
        this.rebuildPolicy(collection);
    }

    public void rebuildPolicy(Collection collection) {
        this.m_focus_list.clear();
        this.m_comp_map.clear();
        this.m_focus_list.addAll(collection);
        for (int i = 0; i < this.m_focus_list.size(); ++i) {
            Component component = (Component)this.m_focus_list.get(i);
            this.m_comp_map.put(component, new Integer(i));
        }
    }

    public Component getComponentAfter(Container container, Component component) {
        Integer n = (Integer)this.m_comp_map.get(component);
        if (n == null) {
            return this.getFirstComponent(container);
        }
        int n2 = n;
        if (++n2 >= this.m_focus_list.size()) {
            n2 = 0;
        }
        return (Component)this.m_focus_list.get(n2);
    }

    public Component getComponentBefore(Container container, Component component) {
        Integer n = (Integer)this.m_comp_map.get(component);
        if (n == null) {
            return this.getFirstComponent(container);
        }
        int n2 = n;
        if (--n2 < 0) {
            n2 = 0;
        }
        return (Component)this.m_focus_list.get(n2);
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public Component getFirstComponent(Container container) {
        if (this.m_focus_list.size() > 0) {
            return (Component)this.m_focus_list.get(0);
        }
        return null;
    }

    public Component getInitialComponent(Window window) {
        return this.getFirstComponent(window);
    }

    public Component getLastComponent(Container container) {
        if (this.m_focus_list.size() > 0) {
            return (Component)this.m_focus_list.get(this.m_focus_list.size() - 1);
        }
        return null;
    }
}

