/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.ImageIcon;

public class IconMemento
implements Externalizable {
    static final long serialVersionUID = 7200914507339096976L;
    public static final int VERSION = 1;
    private byte[] m_image_bytes;
    private transient ImageIcon m_icon;

    public IconMemento() {
    }

    public IconMemento(File file) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
            if (byteArrayOutputStream.size() > 0) {
                this.m_image_bytes = byteArrayOutputStream.toByteArray();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ImageIcon getImageIcon() {
        if (this.m_icon == null && this.m_image_bytes != null) {
            this.m_icon = new ImageIcon(this.m_image_bytes);
        }
        return this.m_icon;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        this.m_image_bytes = (byte[])objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeObject(this.m_image_bytes);
    }
}

