// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::apply_guardrail::_apply_guardrail_output::ApplyGuardrailOutputBuilder;

pub use crate::operation::apply_guardrail::_apply_guardrail_input::ApplyGuardrailInputBuilder;

impl crate::operation::apply_guardrail::builders::ApplyGuardrailInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::apply_guardrail::ApplyGuardrailOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::apply_guardrail::ApplyGuardrailError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.apply_guardrail();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `ApplyGuardrail`.
///
/// <p>The action to apply a guardrail.</p>
/// <p>For troubleshooting some of the common errors you might encounter when using the <code>ApplyGuardrail</code> API, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct ApplyGuardrailFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::apply_guardrail::builders::ApplyGuardrailInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::apply_guardrail::ApplyGuardrailOutput,
        crate::operation::apply_guardrail::ApplyGuardrailError,
    > for ApplyGuardrailFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::apply_guardrail::ApplyGuardrailOutput,
            crate::operation::apply_guardrail::ApplyGuardrailError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl ApplyGuardrailFluentBuilder {
    /// Creates a new `ApplyGuardrailFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the ApplyGuardrail as a reference.
    pub fn as_input(&self) -> &crate::operation::apply_guardrail::builders::ApplyGuardrailInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::apply_guardrail::ApplyGuardrailOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::apply_guardrail::ApplyGuardrailError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::apply_guardrail::ApplyGuardrail::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::apply_guardrail::ApplyGuardrail::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::apply_guardrail::ApplyGuardrailOutput,
        crate::operation::apply_guardrail::ApplyGuardrailError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The guardrail identifier used in the request to apply the guardrail.</p>
    pub fn guardrail_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.guardrail_identifier(input.into());
        self
    }
    /// <p>The guardrail identifier used in the request to apply the guardrail.</p>
    pub fn set_guardrail_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_guardrail_identifier(input);
        self
    }
    /// <p>The guardrail identifier used in the request to apply the guardrail.</p>
    pub fn get_guardrail_identifier(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_guardrail_identifier()
    }
    /// <p>The guardrail version used in the request to apply the guardrail.</p>
    pub fn guardrail_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.guardrail_version(input.into());
        self
    }
    /// <p>The guardrail version used in the request to apply the guardrail.</p>
    pub fn set_guardrail_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_guardrail_version(input);
        self
    }
    /// <p>The guardrail version used in the request to apply the guardrail.</p>
    pub fn get_guardrail_version(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_guardrail_version()
    }
    /// <p>The source of data used in the request to apply the guardrail.</p>
    pub fn source(mut self, input: crate::types::GuardrailContentSource) -> Self {
        self.inner = self.inner.source(input);
        self
    }
    /// <p>The source of data used in the request to apply the guardrail.</p>
    pub fn set_source(mut self, input: ::std::option::Option<crate::types::GuardrailContentSource>) -> Self {
        self.inner = self.inner.set_source(input);
        self
    }
    /// <p>The source of data used in the request to apply the guardrail.</p>
    pub fn get_source(&self) -> &::std::option::Option<crate::types::GuardrailContentSource> {
        self.inner.get_source()
    }
    ///
    /// Appends an item to `content`.
    ///
    /// To override the contents of this collection use [`set_content`](Self::set_content).
    ///
    /// <p>The content details used in the request to apply the guardrail.</p>
    pub fn content(mut self, input: crate::types::GuardrailContentBlock) -> Self {
        self.inner = self.inner.content(input);
        self
    }
    /// <p>The content details used in the request to apply the guardrail.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailContentBlock>>) -> Self {
        self.inner = self.inner.set_content(input);
        self
    }
    /// <p>The content details used in the request to apply the guardrail.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailContentBlock>> {
        self.inner.get_content()
    }
    /// <p>Specifies the scope of the output that you get in the response. Set to <code>FULL</code> to return the entire output, including any detected and non-detected entries in the response for enhanced debugging.</p>
    /// <p>Note that the full output scope doesn't apply to word filters or regex in sensitive information filters. It does apply to all other filtering policies, including sensitive information with filters that can detect personally identifiable information (PII).</p>
    pub fn output_scope(mut self, input: crate::types::GuardrailOutputScope) -> Self {
        self.inner = self.inner.output_scope(input);
        self
    }
    /// <p>Specifies the scope of the output that you get in the response. Set to <code>FULL</code> to return the entire output, including any detected and non-detected entries in the response for enhanced debugging.</p>
    /// <p>Note that the full output scope doesn't apply to word filters or regex in sensitive information filters. It does apply to all other filtering policies, including sensitive information with filters that can detect personally identifiable information (PII).</p>
    pub fn set_output_scope(mut self, input: ::std::option::Option<crate::types::GuardrailOutputScope>) -> Self {
        self.inner = self.inner.set_output_scope(input);
        self
    }
    /// <p>Specifies the scope of the output that you get in the response. Set to <code>FULL</code> to return the entire output, including any detected and non-detected entries in the response for enhanced debugging.</p>
    /// <p>Note that the full output scope doesn't apply to word filters or regex in sensitive information filters. It does apply to all other filtering policies, including sensitive information with filters that can detect personally identifiable information (PII).</p>
    pub fn get_output_scope(&self) -> &::std::option::Option<crate::types::GuardrailOutputScope> {
        self.inner.get_output_scope()
    }
}
