// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// [Compact Font Format (CFF) version 2](https://learn.microsoft.com/en-us/typography/opentype/spec/cff2) table header
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct Cff2HeaderMarker {
    _padding_byte_len: usize,
    top_dict_data_byte_len: usize,
    trailing_data_byte_len: usize,
}

impl Cff2HeaderMarker {
    pub fn major_version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u8::RAW_BYTE_LEN
    }

    pub fn minor_version_byte_range(&self) -> Range<usize> {
        let start = self.major_version_byte_range().end;
        start..start + u8::RAW_BYTE_LEN
    }

    pub fn header_size_byte_range(&self) -> Range<usize> {
        let start = self.minor_version_byte_range().end;
        start..start + u8::RAW_BYTE_LEN
    }

    pub fn top_dict_length_byte_range(&self) -> Range<usize> {
        let start = self.header_size_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn _padding_byte_range(&self) -> Range<usize> {
        let start = self.top_dict_length_byte_range().end;
        start..start + self._padding_byte_len
    }

    pub fn top_dict_data_byte_range(&self) -> Range<usize> {
        let start = self._padding_byte_range().end;
        start..start + self.top_dict_data_byte_len
    }

    pub fn trailing_data_byte_range(&self) -> Range<usize> {
        let start = self.top_dict_data_byte_range().end;
        start..start + self.trailing_data_byte_len
    }
}

impl<'a> FontRead<'a> for Cff2Header<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u8>();
        cursor.advance::<u8>();
        let header_size: u8 = cursor.read()?;
        let top_dict_length: u16 = cursor.read()?;
        let _padding_byte_len = (transforms::subtract(header_size, 5_usize))
            .checked_mul(u8::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(_padding_byte_len);
        let top_dict_data_byte_len = (top_dict_length as usize)
            .checked_mul(u8::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(top_dict_data_byte_len);
        let trailing_data_byte_len = cursor.remaining_bytes() / u8::RAW_BYTE_LEN * u8::RAW_BYTE_LEN;
        cursor.advance_by(trailing_data_byte_len);
        cursor.finish(Cff2HeaderMarker {
            _padding_byte_len,
            top_dict_data_byte_len,
            trailing_data_byte_len,
        })
    }
}

/// [Compact Font Format (CFF) version 2](https://learn.microsoft.com/en-us/typography/opentype/spec/cff2) table header
pub type Cff2Header<'a> = TableRef<'a, Cff2HeaderMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Cff2Header<'a> {
    /// Format major version (set to 2).
    pub fn major_version(&self) -> u8 {
        let range = self.shape.major_version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Format minor version (set to 0).
    pub fn minor_version(&self) -> u8 {
        let range = self.shape.minor_version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Header size (bytes).
    pub fn header_size(&self) -> u8 {
        let range = self.shape.header_size_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Length of Top DICT structure in bytes.
    pub fn top_dict_length(&self) -> u16 {
        let range = self.shape.top_dict_length_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Padding bytes before the start of the Top DICT.
    pub fn _padding(&self) -> &'a [u8] {
        let range = self.shape._padding_byte_range();
        self.data.read_array(range).unwrap()
    }

    /// Data containing the Top DICT.
    pub fn top_dict_data(&self) -> &'a [u8] {
        let range = self.shape.top_dict_data_byte_range();
        self.data.read_array(range).unwrap()
    }

    /// Remaining table data.
    pub fn trailing_data(&self) -> &'a [u8] {
        let range = self.shape.trailing_data_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Cff2Header<'a> {
    fn type_name(&self) -> &str {
        "Cff2Header"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("major_version", self.major_version())),
            1usize => Some(Field::new("minor_version", self.minor_version())),
            2usize => Some(Field::new("header_size", self.header_size())),
            3usize => Some(Field::new("top_dict_length", self.top_dict_length())),
            4usize => Some(Field::new("_padding", self._padding())),
            5usize => Some(Field::new("top_dict_data", self.top_dict_data())),
            6usize => Some(Field::new("trailing_data", self.trailing_data())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Cff2Header<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
