/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// CapacityRequestPolicyApplyConfiguration represents a declarative configuration of the CapacityRequestPolicy type for use
// with apply.
type CapacityRequestPolicyApplyConfiguration struct {
	Default     *resource.Quantity                            `json:"default,omitempty"`
	ValidValues []resource.Quantity                           `json:"validValues,omitempty"`
	ValidRange  *CapacityRequestPolicyRangeApplyConfiguration `json:"validRange,omitempty"`
}

// CapacityRequestPolicyApplyConfiguration constructs a declarative configuration of the CapacityRequestPolicy type for use with
// apply.
func CapacityRequestPolicy() *CapacityRequestPolicyApplyConfiguration {
	return &CapacityRequestPolicyApplyConfiguration{}
}

// WithDefault sets the Default field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Default field is set to the value of the last call.
func (b *CapacityRequestPolicyApplyConfiguration) WithDefault(value resource.Quantity) *CapacityRequestPolicyApplyConfiguration {
	b.Default = &value
	return b
}

// WithValidValues adds the given value to the ValidValues field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ValidValues field.
func (b *CapacityRequestPolicyApplyConfiguration) WithValidValues(values ...resource.Quantity) *CapacityRequestPolicyApplyConfiguration {
	for i := range values {
		b.ValidValues = append(b.ValidValues, values[i])
	}
	return b
}

// WithValidRange sets the ValidRange field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ValidRange field is set to the value of the last call.
func (b *CapacityRequestPolicyApplyConfiguration) WithValidRange(value *CapacityRequestPolicyRangeApplyConfiguration) *CapacityRequestPolicyApplyConfiguration {
	b.ValidRange = value
	return b
}
